package meshvizxlm.eclipsemeshviz.pillargrid;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import meshvizxlm.eclipsemeshviz.DemoSettings;

public class PillarGridFileIO
{
  public void write(PillarGrid pillarGrid, File file) throws IOException
  {
    System.out.println("saving pillar grid into " + file.getName());
    long startTime = System.currentTimeMillis();

    OutputStream fileStream = new FileOutputStream(file);
    DataOutputStream fileWriter = new DataOutputStream(fileStream);

    // writes grid dimensions
    fileWriter.writeInt(pillarGrid.getDimI());
    fileWriter.writeInt(pillarGrid.getDimJ());
    fileWriter.writeInt(pillarGrid.getDimK());
    fileWriter.writeInt(pillarGrid.m_numHFacesAtKLevel);

    // writes num zcorn
    fileWriter.writeLong(pillarGrid.m_numZcorns);

    // writes data
    int i;
    for ( i = 0; i < pillarGrid.m_numZcorns; i++ )
      fileWriter.writeFloat(pillarGrid.m_zcorn[i]);

    for ( i = 0; i < pillarGrid.m_coord.length; i++ )
      fileWriter.writeFloat(pillarGrid.m_coord[i]);

    fileWriter.writeLong(pillarGrid.m_numNonActiveCells);
    if ( pillarGrid.hasNonActiveCells() )
      for ( i = 0; i < pillarGrid.m_numNonActiveCells; i++ )
        fileWriter.writeBoolean(pillarGrid.m_actnum[i]);

    fileWriter.close();
    fileStream.close();
    DemoSettings.displayTime("pillar grid saved", System.currentTimeMillis() - startTime);
  }

  public void read(PillarGrid pillarGrid, File file) throws Exception
  {
    System.out.println("reading pillar grid from " + file.getName());
    FileInputStream inputFile = new FileInputStream(file);
    DataInputStream fileReader = new DataInputStream(inputFile);

    try
    {
      long startTime = System.currentTimeMillis();
      pillarGrid.setDim(fileReader.readInt(), fileReader.readInt(), fileReader.readInt());
      pillarGrid.m_numHFacesAtKLevel = fileReader.readInt();

      long storedNumZCorns = fileReader.readLong();

      if ( pillarGrid.m_numZcorns == storedNumZCorns
          && (!DemoSettings.HORIZONTAL_FAULTS || pillarGrid.m_numHFacesAtKLevel == 2) )
      {
        // read data
        int i;
        for ( i = 0; i < pillarGrid.m_numZcorns; i++ )
          pillarGrid.m_zcorn[i] = fileReader.readFloat();

        for ( i = 0; i < pillarGrid.m_coord.length; i++ )
          pillarGrid.m_coord[i] = fileReader.readFloat();

        pillarGrid.m_numNonActiveCells = fileReader.readLong();
        if ( pillarGrid.m_numNonActiveCells > 0 )
          for ( i = 0; i < pillarGrid.m_numNonActiveCells; i++ )
            pillarGrid.m_actnum[i] = fileReader.readBoolean();
      }
      else
        throw new Exception("wrong file format " + file.getName());

      DemoSettings.displayTime("pillar grid read", System.currentTimeMillis() - startTime);
    }
    catch (Exception ex)
    {
      throw ex;
    }
    finally
    {
      fileReader.close();
      inputFile.close();
    }
  }
}
