package meshvizxlm.eclipsemeshviz.wrappers;

import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterIjk;

public class CellFilter implements MiCellFilterIjk
{
  private EclipseMesh m_mesh;

  private int m_imin;
  private int m_imax;
  private int m_jmin;
  private int m_jmax;
  private int m_kmin;
  private int m_kmax;

  private int[] m_orig; // {imin, imax, jmin, jmax, kmin, kmax}
  private float[] m_dataRange; // {min, max}
  private float m_factor;
  private long m_timeStamp;

  private boolean m_reverse;

  public CellFilter()
  {
    m_orig = new int[6];
    m_dataRange = new float[2];
    m_factor = 1.f;
    m_timeStamp = 0;
  }

  @Override
  public long getTimeStamp()
  {
    return m_timeStamp;
  }

  @Override
  public boolean acceptCell(int i, int j, int k)
  {
    if ( i >= m_imin && i <= m_imax && j >= m_jmin && j <= m_jmax && k >= m_kmin && k <= m_kmax )
    {
      if ( m_reverse == false )
      {
        double val = m_mesh.getDataSet().get(i, j, k);
        return val >= m_dataRange[0] && val <= m_dataRange[1];
      }
      else
      {
        double val = m_mesh.getDataSet().get(i, j, k);
        return !(val >= m_dataRange[0] && val <= m_dataRange[1]);
      }
    }
    else
      return false;
  }

  public void setMesh(EclipseMesh mesh)
  {
    long ni = mesh.getDimI();
    if ( ni != mesh.getTopology().getNumCellsI() )
      setMesh(mesh, ni / mesh.getTopology().getNumCellsI(), true);
    else
      setMesh(mesh, 1.0f, true);
  }

  public void setMesh(EclipseMesh mesh, float factor, boolean reset)
  {
    m_factor = factor;
    m_mesh = mesh;

    final int meshDimI = mesh.getDimI();
    final int meshDimJ = mesh.getDimJ();
    final int meshDimK = mesh.getDimK();

    if ( reset )
    {
      setROI(0, meshDimI, 0, meshDimJ, 0, meshDimK);
      setDataRange((float) m_mesh.getDataSet().getMin(), (float) m_mesh.getDataSet().getMax());
    }
    else
      setROI(m_orig[0], m_orig[1], m_orig[2], m_orig[3], m_orig[4], m_orig[5]);
  }

  public void setROI(int imin, int meshDimI, int jmin, int meshDimJ, int kmin, int meshDimK)
  {
    m_orig[0] = imin;
    m_orig[1] = meshDimI;
    m_orig[2] = jmin;
    m_orig[3] = meshDimJ;
    m_orig[4] = kmin;
    m_orig[5] = meshDimK;

    m_imin = (int) (imin / m_factor);
    m_imax = (int) (meshDimI / m_factor);
    m_jmin = (int) (jmin / m_factor);
    m_jmax = (int) (meshDimJ / m_factor);
    m_kmin = (int) (kmin / m_factor);
    m_kmax = (int) (meshDimK / m_factor);

    ++m_timeStamp;
  }

  public int[] getROI()
  {
    return m_orig;
  }

  public void setDataRange(float min, float max)
  {
    m_dataRange[0] = min;
    m_dataRange[1] = max;

    ++m_timeStamp;
  }

  public float[] getDataRange()
  {
    return m_dataRange;
  }

  public boolean isFiltering()
  {
    return m_imin > 0 || m_jmin > 0 || m_kmin > 0 || m_imax + 1 < m_mesh.getDimI() || m_jmax + 1 < m_mesh.getDimJ()
        || m_kmax + 1 < m_mesh.getDimK() || m_dataRange[0] > m_mesh.getDataSet().getMin()
        || m_dataRange[1] < m_mesh.getDataSet().getMax();
  }

  public void setReverseDataFiltering(boolean active)
  {
    m_reverse = active;
  }
}
