package meshvizxlm.eclipsemeshviz.wrappers;

import com.openinventor.meshvizxlm.mesh.MiMeshIjk;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetI;
import com.openinventor.meshvizxlm.mesh.topology.MiHexahedronTopologyExplicitIjk;

import meshvizxlm.eclipsemeshviz.wrappers.property.BoundedProperty;

public abstract class EclipseMesh implements MiMeshIjk<MiHexahedronTopologyExplicitIjk>
{
  public abstract double getXCenter();

  public abstract double getYCenter();

  public abstract double getZCenter();

  public abstract double[] getBBSize();

  public abstract BoundedProperty getDataSet();

  public abstract MiScalardSetI getPerNodeDataSet();

  public int getDimI()
  {
    // return getTopology().getNumCellsI();
    return m_numCellsI;
  }

  public int getDimJ()
  {
    // return getTopology().getNumCellsJ();
    return m_numCellsJ;
  }

  public int getDimK()
  {
    // return getTopology().getNumCellsK();
    return m_numCellsK;
  }

  protected int m_numCellsI;
  protected int m_numCellsJ;
  protected int m_numCellsK;

}
