package meshvizxlm.eclipsemeshviz.wrappers.geometry;

import java.util.Vector;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;

public class CachedPillarGeometry extends AbstractCachedPillarGeometry
{
  private Vector<double[]> m_pillarPoints;

  public CachedPillarGeometry(PillarGrid grid)
  {
    super(grid);
    m_pillarPoints = new Vector<double[]>((m_grid.getDimI() + 1) * (m_grid.getDimJ() + 1) * (m_grid.getDimK() + 1));
  }

  @Override
  public long size()
  {
    return m_pillarPoints.size();
  }

  @Override
  protected double[] generateCoord(long id)
  {
    return m_pillarPoints.get((int) id);
  }

  @Override
  public int addPoint(int zcornIndex)
  {
    int index = m_pillarPoints.size();
    m_pillarPoints.add(m_grid.computePillarVertex(zcornIndex));
    return index;
  }

  @Override
  public long getMemoryFootPrint()
  {
    return 12 * m_pillarPoints.size();
  }
}
