package meshvizxlm.eclipsemeshviz.wrappers.geometry;

import java.util.Arrays;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;

public class IndexedPillarGeometry extends AbstractCachedPillarGeometry
{
  private int[] m_zcornIndices;
  int m_index = 0;

  public IndexedPillarGeometry(PillarGrid grid)
  {
    super(grid);
    m_zcornIndices = new int[(m_grid.getDimI() + 1) * (m_grid.getDimJ() + 1) * (m_grid.getDimK() + 1)];
  }

  private void ensureCapacity(int index)
  {
    if ( index >= m_zcornIndices.length )
      m_zcornIndices = Arrays.copyOf(m_zcornIndices, (int) (m_zcornIndices.length * 1.01));
  }

  @Override
  public long size()
  {
    return m_zcornIndices.length;
  }

  @Override
  public int addPoint(int pointIndex)
  {
    ensureCapacity(m_index);
    m_zcornIndices[m_index++] = pointIndex;
    return m_index - 1;
  }

  @Override
  protected double[] generateCoord(long id)
  {
    return m_grid.computePillarVertex(m_zcornIndices[(int) id]);
  }

  @Override
  public long getMemoryFootPrint()
  {
    return 4 * m_zcornIndices.length;
  }
}
