package meshvizxlm.eclipsemeshviz.wrappers.property;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;

public class AnimatedPillarProperty extends PillarDepth
{
  static protected final int NUM_FRAMES = 100;
  static protected final double TWO_PI = 2 * Math.PI;

  protected double[] m_unit_sin_table = new double[NUM_FRAMES];
  protected int m_frame;

  public AnimatedPillarProperty(PillarGrid grid)
  {
    super(grid);

    m_scale = (getMax() - getMin()) / 2. / Math.sqrt(Math.pow(m_grid.getDimI(), 2) + Math.pow(m_grid.getDimJ(), 2));
    m_halfIRange = m_grid.getDimI() / 2.;
    m_halfJRange = m_grid.getDimJ() / 2.;
    m_frame = 0;

    for ( int i = 0; i < NUM_FRAMES; i++ )
    {
      m_unit_sin_table[i] = -1;
    }
  }

  public void setFrame(int frame)
  {
    m_frame = frame;
    touch();
  }

  public int getFrame()
  {
    return m_frame;
  }

  @Override
  public double get(int i, int j, int k)
  {
    double originalValue = super.get(i, j, k);

    if ( m_frame == 0 )
    {
      return originalValue;
    }

    if ( m_unit_sin_table[m_frame] < 0.0 )
    {
      m_unit_sin_table[m_frame] = Math.sin(TWO_PI * (m_frame / 100.0));
    }

    double unit_sin_frame = m_unit_sin_table[m_frame];
    return originalValue + (unit_sin_frame * (((i - m_halfIRange) + (j - m_halfJRange)) * m_scale * 0.35));
  }
}
