package meshvizxlm.eclipsemeshviz.wrappers.subsampled;

import com.openinventor.meshvizxlm.mesh.MiMeshIjk;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetI;
import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryI;
import com.openinventor.meshvizxlm.mesh.topology.MiHexahedronTopologyExplicitIjk;

import meshvizxlm.eclipsemeshviz.isosurface.CellToNodeExtractor;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;
import meshvizxlm.eclipsemeshviz.wrappers.EclipseMesh;
import meshvizxlm.eclipsemeshviz.wrappers.PillarMesh;
import meshvizxlm.eclipsemeshviz.wrappers.property.BoundedProperty;

public class SubSampledMesh<T extends PillarGrid> extends EclipseMesh implements MiAdjustableHexaMeshIjk
{

  private double m_ratio;
  private PillarMesh<T> m_mesh;
  private SubSampledTopology m_topology;
  private SubSampledScalarSet m_dataset;
  private CellToNodeExtractor m_extractor;

  public SubSampledMesh(PillarMesh<T> mesh, double ratio)
  {
    m_ratio = ratio;
    int step = (int) (1. / ratio);
    m_mesh = mesh;
    m_topology = new SubSampledTopology(m_mesh.getTopology(), step);
    m_dataset =
        new SubSampledScalarSet(m_mesh.getDataSet(), mesh.getTopology().getNumCellsI(), mesh.getTopology()
            .getNumCellsJ(), mesh.getTopology().getNumCellsK(), step);
    m_extractor = new CellToNodeExtractor(true);
    m_numCellsI = m_mesh.getTopology().getNumCellsI();
    m_numCellsJ = m_mesh.getTopology().getNumCellsJ();
    m_numCellsK = m_mesh.getTopology().getNumCellsK();
  }

  public SubSampledMesh(PillarMesh<T> mesh)
  {
    this(mesh, 0.5);
  }

  @Override
  public void adjust(double ratio)
  {
    int step = (int) (1. / ratio);
    m_ratio = 1 / (float) step;
    m_topology.adjust(step);
    m_dataset.adjust(step);
  }

  @Override
  public double getRatio()
  {
    return m_ratio;
  }

  public int getStep()
  {
    return (int) Math.round((1. / m_ratio));
  }

  @Override
  public MiGeometryI getGeometry()
  {
    return m_mesh.getGeometry();
  }

  @Override
  public MiHexahedronTopologyExplicitIjk getTopology()
  {
    return m_topology;
  }

  @Override
  public double getXCenter()
  {
    return m_mesh.getXCenter();
  }

  @Override
  public double getYCenter()
  {
    return m_mesh.getYCenter();
  }

  @Override
  public double getZCenter()
  {
    return m_mesh.getZCenter();
  }

  @Override
  public double[] getBBSize()
  {
    return m_mesh.getBBSize();
  }

  @Override
  public BoundedProperty getDataSet()
  {
    return m_dataset;
  }

  @Override
  public MiScalardSetI getPerNodeDataSet()
  {
    return m_extractor.extract(m_mesh);
  }

  public void updateDataSet(BoundedProperty sset)
  {
    m_dataset =
        new SubSampledScalarSet(sset, ((MiMeshIjk<MiHexahedronTopologyExplicitIjk>) m_mesh).getTopology()
            .getNumCellsI(), ((MiMeshIjk<MiHexahedronTopologyExplicitIjk>) m_mesh).getTopology().getNumCellsJ(),
            ((MiMeshIjk<MiHexahedronTopologyExplicitIjk>) m_mesh).getTopology().getNumCellsK(), (int) (1. / m_ratio));
  }

}
