package meshvizxlm.eclipsemeshviz.wrappers.subsampled;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.topology.MiHexahedronTopologyExplicitIjk;

public class SubSampledTopology implements MiHexahedronTopologyExplicitIjk
{

  protected MiHexahedronTopologyExplicitIjk m_topology;
  protected long m_topoTS;

  protected long m_timeStamp;
  protected int m_step;
  protected int m_numI;
  protected int m_numJ;
  protected int m_numK;

  public SubSampledTopology(MiHexahedronTopologyExplicitIjk topology, int step)
  {
    m_topology = topology;
    m_topoTS = m_topology.getTimeStamp();

    adjust(step);
  }

  public void adjust(int step)
  {
    m_step = step;
    m_numI = m_topology.getNumCellsI() / m_step;
    if ( m_numI == 0 )
      ++m_numI;
    m_numJ = m_topology.getNumCellsJ() / m_step;
    if ( m_numJ == 0 )
      ++m_numJ;
    m_numK = m_topology.getNumCellsK() / m_step;
    if ( m_numK == 0 )
      ++m_numK;
    m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  @Override
  public int getNumCellsI()
  {
    return m_numI;
  }

  @Override
  public int getNumCellsJ()
  {
    return m_numJ;
  }

  @Override
  public int getNumCellsK()
  {
    return m_numK;
  }

  @Override
  public boolean isDead(int i, int j, int k)
  {
    int firstI = i * m_step;
    int lastI = i < m_numI - 1 ? firstI + m_step - 1 : m_topology.getNumCellsI() - 1;
    int firstJ = j * m_step;
    int lastJ = j < m_numJ - 1 ? firstJ + m_step - 1 : m_topology.getNumCellsJ() - 1;
    int firstK = k * m_step;
    int lastK = k < m_numK - 1 ? firstK + m_step - 1 : m_topology.getNumCellsK() - 1;

    for ( int ii = firstI; ii <= lastI; ++ii )
      for ( int jj = firstJ; jj <= lastJ; ++jj )
        for ( int kk = firstK; kk <= lastK; ++kk )
          if ( m_topology.isDead(ii, jj, kk) )
            return true;

    return false;
  }

  @Override
  public String getCellName(int i, int j, int k)
  {
    return "(" + i + "," + j + "," + k + ")";
  }

  @Override
  public long getTimeStamp()
  {
    if ( m_topoTS != m_topology.getTimeStamp() )
      m_timeStamp = MxTimeStamp.getTimeStamp();

    return m_timeStamp;
  }

  @Override
  public boolean hasDeadCells()
  {
    return m_topology.hasDeadCells();
  }

  @Override
  public long[] getCellNodeIndices(int i, int j, int k, long[] nodeIndices)
  {
    long[] indices = new long[8];
    if ( nodeIndices == null || nodeIndices.length < 8 )
      nodeIndices = new long[8];

    int firstI = i * m_step;
    int lastI = i < m_numI - 1 ? firstI + m_step - 1 : m_topology.getNumCellsI() - 1;
    int firstJ = j * m_step;
    int lastJ = j < m_numJ - 1 ? firstJ + m_step - 1 : m_topology.getNumCellsJ() - 1;
    int firstK = k * m_step;
    int lastK = k < m_numK - 1 ? firstK + m_step - 1 : m_topology.getNumCellsK() - 1;

    m_topology.getCellNodeIndices(firstI, firstJ, firstK, indices);
    nodeIndices[0] = indices[0];
    m_topology.getCellNodeIndices(lastI, firstJ, firstK, indices);
    nodeIndices[1] = indices[1];
    m_topology.getCellNodeIndices(lastI, lastJ, firstK, indices);
    nodeIndices[2] = indices[2];
    m_topology.getCellNodeIndices(firstI, lastJ, firstK, indices);
    nodeIndices[3] = indices[3];
    m_topology.getCellNodeIndices(firstI, firstJ, lastK, indices);
    nodeIndices[4] = indices[4];
    m_topology.getCellNodeIndices(lastI, firstJ, lastK, indices);
    nodeIndices[5] = indices[5];
    m_topology.getCellNodeIndices(lastI, lastJ, lastK, indices);
    nodeIndices[6] = indices[6];
    m_topology.getCellNodeIndices(firstI, lastJ, lastK, indices);
    nodeIndices[7] = indices[7];

    return nodeIndices;
  }

  @Override
  public long getEndNodeId()
  {
    return m_topology.getEndNodeId();
  }

  @Override
  public long getBeginNodeId()
  {
    return 0;
  }

  @Override
  public StorageLayoutIJK getStorageLayout()
  {
    return StorageLayoutIJK.UNKNOWN;
  }
}
