package meshvizxlm.mapping;

import com.openinventor.inventor.SbVec3d;
import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetI;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetIjk;
import com.openinventor.meshvizxlm.mesh.data.MiVec3dSetIjk;

import meshvizxlm.mesh.data.MbVec3SetI;

public class MyVec3Set extends MbVec3SetI implements MiVec3dSetIjk
{
  protected int m_dimI;
  protected int m_dimJ;
  protected int m_dimK;
  protected boolean m_normalized;
  protected boolean m_random;
  protected SbVec3d m_min;
  protected SbVec3d m_max;

  public MyVec3Set(int dim, DataBinding dataBinding)
  {
    super();

    m_name = "MyVec3Set";
    m_dimI = dim;
    m_dimJ = dim;
    m_dimK = dim;
    m_normalized = false;
    m_random = false;

    setBinding(dataBinding);
  }

  public MyVec3Set(int dimX, int dimY, int dimZ)
  {
    this(dimX, dimY, dimZ, DataBinding.PER_NODE);
  }

  public MyVec3Set(int dimX, int dimY, int dimZ, DataBinding dataBinding)
  {
    super();

    m_name = "MyVec3Set";
    m_dimI = dimX;
    m_dimJ = dimY;
    m_dimK = dimZ;
    m_normalized = false;
    m_random = false;

    setBinding(dataBinding);
  }

  @Override
  public double[] get(int i, int j, int k)
  {
    return get(k * m_dimI * m_dimJ + j * m_dimI + i);
  }

  @Override
  public StorageLayoutIJK getStorageLayout()
  {
    return StorageLayoutIJK.UNKNOWN;
  }

  @Override
  public DataBinding getBinding()
  {
    return this.m_binding;
  }

  public void setBinding(DataBinding binding)
  {
    if ( binding != m_binding || m_xArray == null )
    {
      if ( binding == DataBinding.PER_NODE )
      {
        m_dimI++;
        m_dimJ++;
        m_dimK++;
      }
      else if ( m_xArray != null )
      {
        m_dimI--;
        m_dimJ--;
        m_dimK--;
      }
      m_binding = binding;
      regularVec(m_normalized);
      m_timeStamp++;
    }
  }

  public SbVec3d getMin()
  {
    return m_min;
  }

  public SbVec3d getMax()
  {
    return m_max;
  }

  public void regularVec(boolean normalize)
  {
    int comp;
    int d = getSize();
    m_xArray = new double[d];
    m_yArray = new double[d];
    m_zArray = new double[d];
    SbVec3d vec = new SbVec3d();
    m_min = new SbVec3d();
    m_max = new SbVec3d();

    for ( int i = 0; i < d; ++i )
    {
      vec = computeValue(i, d, vec);
      if ( normalize )
        vec.normalize();

      if ( i == 0 )
      {
        m_min.setValue(vec);
        m_max.setValue(vec);
      }
      else
      {
        comp = compare(vec, m_min);
        if ( comp < 0 )
          m_min.setValue(vec);

        comp = compare(vec, m_max);
        if ( comp > 0 )
          m_max.setValue(vec);
      }

      m_xArray[i] = vec.array[0];
      m_yArray[i] = vec.array[1];
      m_zArray[i] = vec.array[2];
    }
    this.m_timeStamp++;
    this.m_normalized = normalize;
    this.m_random = false;
  }

  @Override
  public int getSize()
  {
    return m_dimI * m_dimJ * m_dimK;
  }

  protected SbVec3d computeValue(int i, int d, SbVec3d vec)
  {
    double z = i / (m_dimI * m_dimJ) / m_dimK;
    int n = i % (m_dimI * m_dimJ);
    double y = (n / m_dimI) / (double) m_dimJ;
    double x = (n % m_dimI) / (double) m_dimI;

    y = 1 - y;
    z = Math.cos(Math.PI * x) * Math.cos(z);

    if ( vec == null )
      return new SbVec3d(x, y, z);

    vec.array[0] = x;
    vec.array[1] = y;
    vec.array[2] = z;
    return vec;
  }

  private int compare(SbVec3d v1, SbVec3d v2)
  {
    if ( v1.equals(v2, 1e-5) )
      return 0;

    double l1 = v1.length();
    double l2 = v2.length();

    if ( l1 > l2 )
      return 1;
    return -1;
  }

  public class Magnitude implements MiScalardSetI, MiScalardSetIjk
  {
    private SbVec3d m_vec;

    public Magnitude()
    {
      m_vec = new SbVec3d();
    }

    @Override
    public double get(long i)
    {
      int index = (int) i;
      m_vec.setValue(m_xArray[index], m_yArray[index], m_zArray[index]);

      return m_vec.length();
    }

    @Override
    public double get(int i, int j, int k)
    {
      return get(k * m_dimI * m_dimJ + j * m_dimI + i);
    }

    @Override
    public DataBinding getBinding()
    {
      return MyVec3Set.this.getBinding();
    }

    @Override
    public String getName()
    {
      return "Magnitude";
    }

    @Override
    public long getTimeStamp()
    {
      return MyVec3Set.this.getTimeStamp();
    }

    @Override
    public StorageLayoutIJK getStorageLayout()
    {
      return MyVec3Set.this.getStorageLayout();
    }

    public double getMin()
    {
      return MyVec3Set.this.getMin().length();
    }

    public double getMax()
    {
      return MyVec3Set.this.getMax().length();
    }
  }
}
