package meshvizxlm.mapping.outline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshvizxlm.extractors.MiExtractorCallback;
import com.openinventor.meshvizxlm.mapping.nodes.*;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterI;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterIj;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterIjk;

import meshvizxlm.mapping.MyVec3Set;
import meshvizxlm.mesh.MbSampleMeshBuilder;
import meshvizxlm.mesh.data.MbScalarSetI;
import meshvizxlm.mesh.data.MbScalarSetIj;
import meshvizxlm.mesh.data.MbScalarSetIjk;
import meshvizxlm.mesh.surfaces.MbSurfaceMeshCurvilinear;
import meshvizxlm.mesh.surfaces.MbSurfaceMeshQuadrangle;
import meshvizxlm.mesh.volumes.MbVertexHexahedronMeshIjk;
import meshvizxlm.mesh.volumes.MbVolumeMeshHexahedron;
import meshvizxlm.mesh.volumes.MbVolumeMeshTetrahedron;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  // ///// INNER CLASS
  class MyExtractorCallback implements MiExtractorCallback
  {
    @Override
    public void beginCallback(boolean geomChanged, boolean topoChanged, boolean dataSetChanged)
    {
      if ( topoChanged )
        System.out.println("outline computation started ...");
      if ( dataSetChanged )
        System.out.println("dataset computation started ...");
    }

    @Override
    public void endCallback(boolean geomChanged, boolean topoChanged, boolean dataSetChanged)
    {
      if ( topoChanged )
        System.out.println("outline computation finished ...");
      if ( dataSetChanged )
        System.out.println("dataset computation finished ...");
    }
  }

  class CellFilterI implements MiCellFilterI
  {
    @Override
    public boolean acceptCell(long cellIndex)
    {
      int index = (int) cellIndex;
      int ij = index % (NUM_CELL_J * NUM_CELL_I);
      int j = ij / NUM_CELL_I;
      int i = ij % NUM_CELL_I;

      if ( NUM_CELL_I / 3. < i && i <= 2 * NUM_CELL_I / 3. && NUM_CELL_J / 3. < j && j <= 2 * NUM_CELL_J / 3. )
        return false;

      return true;
    }

    @Override
    public long getTimeStamp()
    {
      return 0;
    }
  }

  class CellFilterIj implements MiCellFilterIj
  {
    @Override
    public boolean acceptCell(long i, long j)
    {
      if ( NUM_CELL_I / 3. < i && i <= 2 * NUM_CELL_I / 3. && NUM_CELL_J / 3. < j && j <= 2 * NUM_CELL_J / 3. )
        return false;

      return true;
    }

    @Override
    public long getTimeStamp()
    {
      return 0;
    }
  }

  class CellFilterIjk implements MiCellFilterIjk
  {
    @Override
    public boolean acceptCell(int i, int j, int k)
    {
      if ( NUM_CELL_I / 3. < i && i <= 2 * NUM_CELL_I / 3. && NUM_CELL_J / 3. < j && j <= 2 * NUM_CELL_J / 3.
          && k > NUM_CELL_K / 2. )
        return false;

      return true;
    }

    @Override
    public long getTimeStamp()
    {
      return 0;
    }
  }

  private static final int NUM_CELL_I = 10;
  private static final int NUM_CELL_J = 5;
  private static final int NUM_CELL_K = 20;

  private IViewerExaminer m_renderArea;
  private MbSampleMeshBuilder m_meshBuilder;
  private MbVolumeMeshTetrahedron m_meshTetra;
  private MbVolumeMeshHexahedron m_meshHexa;
  private MbVertexHexahedronMeshIjk m_meshVertexHexaIjk;
  private MbSurfaceMeshCurvilinear m_meshCurvilinear;
  private MbSurfaceMeshQuadrangle m_meshQuadrangle;
  private MoMesh m_moMesh;
  private MoScalarSetI m_moScalarSet;
  private MoScalarSetIj m_moScalarSetIj;
  private MoScalarSetIjk m_moScalarSetIjk;
  private MoVec3SetIj m_moVec3SetIj;
  private MoVec3SetIjk m_moVec3SetIjk;
  private MoPredefinedColorMapping m_colMap;
  private SoSwitch m_filterSwitch;
  private SoSwitch m_displaySwitch;
  private SoSwitch m_vectorSwitch;
  private MoMeshVector m_moVector;
  private MoCellFilter m_moCellFilter;

  public Main()
  {
    m_meshBuilder = new MbSampleMeshBuilder();

    double[] min = { 0, 0, 0 };
    double[] max = { NUM_CELL_I, NUM_CELL_J, NUM_CELL_K };
    m_meshHexa = m_meshBuilder.getMeshHexahedron(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);

    m_meshTetra = null;
    m_meshVertexHexaIjk = null;
    m_meshCurvilinear = null;
    m_meshQuadrangle = null;
  }

  @Override
  public void start()
  {
    SoSeparator root = buildSceneGraph();

    m_renderArea = ViewerComponentsFactory.createViewerExaminer();
    m_renderArea.setSceneGraph(root);
    m_renderArea.viewAll();

    String[] items =
        new String[] { "Tetrahedron", "Hexahedron", "Vertex Hexahedron IJK", "Curvilinear Surface", "Quadrangle" };
    final JComboBox<String> meshBox = new JComboBox<>(items);

    final JCheckBox filterBox = new JCheckBox("Cell filter");
    filterBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( filterBox.isSelected() )
          m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    final JCheckBox skinBox = new JCheckBox("Display skin/surface");
    skinBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( skinBox.isSelected() )
        {
          if ( meshBox.getSelectedIndex() > 2 )
            // surface
            m_displaySwitch.whichChild.setValue(1);
          else
            // skin
            m_displaySwitch.whichChild.setValue(0);
        }
        else
          m_displaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });
    skinBox.setSelected(true);

    final JCheckBox vectorBox = new JCheckBox("Display vectors");
    vectorBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( vectorBox.isSelected() )
          m_vectorSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_vectorSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    JPanel boxesPanel = new JPanel();
    boxesPanel.setLayout(new BoxLayout(boxesPanel, BoxLayout.X_AXIS));
    boxesPanel.add(filterBox);
    boxesPanel.add(skinBox);
    boxesPanel.add(vectorBox);

    JLabel label = new JLabel("Mesh       ");
    meshBox.setSelectedIndex(1);
    meshBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        switch ( meshBox.getSelectedIndex() )
        {
        case 0 : // Tetrahedron
          if ( m_meshTetra == null )
          {
            double[] min = { 0, 0, 0 };
            double[] max = { NUM_CELL_I, NUM_CELL_J, NUM_CELL_K };
            m_meshTetra = m_meshBuilder.getMeshTetrahedron(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);
          }
          MbScalarSetI scalarSet = m_meshTetra.getScalarSet("$ScalarSetX");
          m_moScalarSet.setScalarSet(scalarSet);
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
          m_moVector.scaleFactor.setValue(1.f);
          m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
          filterBox.setEnabled(false);
          if ( skinBox.isSelected() )
            m_displaySwitch.whichChild.setValue(0);
          m_moMesh.setMesh(m_meshTetra);
          break;
        case 1 : // hexahedron
          scalarSet = m_meshHexa.getScalarSet("$ScalarSetX");
          m_moScalarSet.setScalarSet(scalarSet);
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
          m_moVector.scaleFactor.setValue(1.f);
          m_moCellFilter.setCellFilter(new CellFilterI());
          if ( filterBox.isSelected() )
            m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          filterBox.setEnabled(true);
          if ( skinBox.isSelected() )
            m_displaySwitch.whichChild.setValue(0);
          m_moMesh.setMesh(m_meshHexa);
          break;
        case 2 : // Vertex hexahedron IJK
          if ( m_meshVertexHexaIjk == null )
          {
            double[] min = { 0, 0, 0 };
            double[] max = { NUM_CELL_I, NUM_CELL_J, NUM_CELL_K };
            m_meshVertexHexaIjk =
                m_meshBuilder.getVertexHexahedronMeshIjk(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);
          }
          MbScalarSetIjk scalarSetIjk = m_meshVertexHexaIjk.getScalarSetIjk("$CellId");
          m_moScalarSetIjk.setScalarSet(scalarSetIjk);
          m_colMap.minValue.setValue((float) scalarSetIjk.getMin());
          m_colMap.maxValue.setValue((float) scalarSetIjk.getMax());
          m_moVec3SetIjk.setVec3Set(m_meshVertexHexaIjk.getVec3SetIjk("$CellCenter"));
          m_moVector.scaleFactor.setValue(0.1f);
          m_moCellFilter.setCellFilter(new CellFilterIjk());
          if ( filterBox.isSelected() )
            m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          filterBox.setEnabled(true);
          if ( skinBox.isSelected() )
            m_displaySwitch.whichChild.setValue(0);
          m_moMesh.setMesh(m_meshVertexHexaIjk);
          break;
        case 3 : // Curvilinear surface
          if ( m_meshCurvilinear == null )
          {
            double[] origin = { 0, 0, 0 };
            double[] stepVecI = { 1, 0, 0 };
            double[] stepVecJ = { 0, 1, 0 };
            m_meshCurvilinear =
                m_meshBuilder.getSurfaceMeshCurvilinear(NUM_CELL_I, NUM_CELL_J, origin, stepVecI, stepVecJ);
          }
          MbScalarSetIj scalarSetIj = m_meshCurvilinear.getScalarSetIj("$ScalarSetX");
          m_moScalarSetIj.setScalarSet(scalarSetIj);
          m_colMap.minValue.setValue((float) scalarSetIj.getMin());
          m_colMap.maxValue.setValue((float) scalarSetIj.getMax());
          m_moCellFilter.setCellFilter(new CellFilterIj());
          if ( filterBox.isSelected() )
            m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          filterBox.setEnabled(true);
          m_moVec3SetIj.setVec3Set(m_meshCurvilinear.getVec3SetIj("$MyGeometry"));
          m_moVector.scaleFactor.setValue(.3f);
          if ( skinBox.isSelected() )
            m_displaySwitch.whichChild.setValue(1);
          m_moMesh.setMesh(m_meshCurvilinear);
          break;
        case 4 : // Quadrangle surface
          if ( m_meshQuadrangle == null )
          {
            double[] origin = { 0, 0, 0 };
            double[] stepVecI = { 1, 0, 0 };
            double[] stepVecJ = { 0, 1, 0 };
            m_meshQuadrangle =
                m_meshBuilder.getSurfaceMeshQuadrangle(NUM_CELL_I, NUM_CELL_J, origin, stepVecI, stepVecJ, null);
          }
          scalarSet = m_meshQuadrangle.getScalarSet("$ScalarSetX");
          m_moScalarSet.setScalarSet(scalarSet);
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
          m_moCellFilter.setCellFilter(new CellFilterI());
          if ( filterBox.isSelected() )
            m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
          filterBox.setEnabled(true);
          m_moVector.scaleFactor.setValue(1.f);
          if ( skinBox.isSelected() )
            m_displaySwitch.whichChild.setValue(1);
          m_moMesh.setMesh(m_meshQuadrangle);
          break;
        default:
          break;
        }
      }
    });
    JPanel meshPanel = new JPanel();
    meshPanel.setLayout(new BoxLayout(meshPanel, BoxLayout.X_AXIS));
    meshPanel.add(label);
    meshPanel.add(meshBox);

    JPanel panel2 = new JPanel(new BorderLayout());
    panel2.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, null, null));
    panel2.add(boxesPanel, BorderLayout.NORTH);
    panel2.add(meshPanel, BorderLayout.CENTER);

    final Component component = m_renderArea.getComponent();
    component.setPreferredSize(new Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(panel2, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    m_renderArea.dispose();
  }

  private SoSeparator buildSceneGraph()
  {
    SoShapeHints sh = new SoShapeHints();
    sh.vertexOrdering.setValue(SoShapeHints.VertexOrderings.CLOCKWISE);

    m_moMesh = new MoMesh();
    m_moMesh.setMesh(m_meshHexa);

    m_filterSwitch = new SoSwitch();
    m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    m_moCellFilter = new MoCellFilter();
    m_moCellFilter.setCellFilter(new CellFilterI());

    MbScalarSetI scalarSet = m_meshHexa.getScalarSet("$ScalarSetX");
    m_colMap = new MoPredefinedColorMapping();
    m_colMap.minValue.setValue((float) scalarSet.getMin());
    m_colMap.maxValue.setValue((float) scalarSet.getMax());
    m_colMap.predefColorMap.setValue(MoPredefinedColorMapping.PredefColorMapping.STANDARD);

    m_moScalarSet = new MoScalarSetI();
    m_moScalarSet.setScalarSet(scalarSet);

    m_moScalarSetIj = new MoScalarSetIj();
    m_moScalarSetIjk = new MoScalarSetIjk();

    MoDataBinding dataBinding = new MoDataBinding();
    dataBinding.dataBinding.setValue(MoDataBinding.DataBinding.PER_NODE);

    // mesh skin/surface
    MoDrawStyle style = new MoDrawStyle();
    style.displayFaces.setValue(false);
    style.displayEdges.setValue(true);

    MoMaterial material = new MoMaterial();
    material.lineColoring.setValue(MoMaterial.ColoringType.COLOR);
    material.lineColor.setValue(0.8f, 0.8f, 0.8f);

    SoPickStyle pickStyle = new SoPickStyle();
    pickStyle.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    SoLightModel lModel = new SoLightModel();
    lModel.model.setValue(SoLightModel.Models.BASE_COLOR);

    MoMeshSkin skin = new MoMeshSkin();
    skin.colorScalarSetId.setValue(-1);

    MoMeshSurface surface = new MoMeshSurface();
    surface.colorScalarSetId.setValue(-1);

    m_displaySwitch = new SoSwitch();
    {
      m_displaySwitch.addChild(skin);
      m_displaySwitch.addChild(surface);
    }
    m_displaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    SoSeparator skinSep = new SoSeparator();
    {
      skinSep.addChild(style);
      skinSep.addChild(material);
      skinSep.addChild(pickStyle);
      skinSep.addChild(lModel);
      skinSep.addChild(m_displaySwitch);
    }

    // Outline
    MoMeshOutline outline = new MoMeshOutline();
    outline.setExtractorCallback(new MyExtractorCallback());

    // This mesh is used to connect the cells generated mesh as input of the
    // vectors
    MoMesh outlineMesh = new MoMesh();
    outlineMesh.connectFrom(outline);

    MyVec3Set myVec3Set = new MyVec3Set(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K);
    MoVec3SetI moVec3Set = new MoVec3SetI();
    moVec3Set.setVec3Set(myVec3Set);

    m_moVec3SetIj = new MoVec3SetIj();
    m_moVec3SetIjk = new MoVec3SetIjk();

    m_vectorSwitch = new SoSwitch();
    m_moVector = new MoMeshVector();
    m_moVector.vectorSetId.setValue(0);

    SoSeparator root = new SoSeparator();
    {
      m_filterSwitch.addChild(m_moCellFilter);
      m_vectorSwitch.addChild(m_moVector);

      root.addChild(sh);
      root.addChild(m_moMesh);
      root.addChild(m_filterSwitch);
      root.addChild(m_colMap);
      root.addChild(m_moScalarSet);
      root.addChild(m_moScalarSetIj);
      root.addChild(m_moScalarSetIjk);
      root.addChild(dataBinding);
      root.addChild(skinSep);
      root.addChild(outline);
      root.addChild(outlineMesh);
      root.addChild(moVec3Set);
      root.addChild(m_moVec3SetIj);
      root.addChild(m_moVec3SetIjk);
      root.addChild(m_vectorSwitch);
    }

    return root;
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Outline Example");
  }

}
