package meshvizxlm.mapping.picking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.details.SoDetail;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.meshvizxlm.mapping.MoMeshVizDataMapping.MeshType;
import com.openinventor.meshvizxlm.mapping.details.MoFaceDetailI;
import com.openinventor.meshvizxlm.mapping.details.MoFaceDetailIj;
import com.openinventor.meshvizxlm.mapping.details.MoFaceDetailIjk;
import com.openinventor.meshvizxlm.mapping.details.MoMeshDetail;
import com.openinventor.meshvizxlm.mapping.nodes.*;

import meshvizxlm.mesh.MbSampleMeshBuilder;
import meshvizxlm.mesh.data.MbScalarSetI;
import meshvizxlm.mesh.data.MbScalarSetIj;
import meshvizxlm.mesh.data.MbScalarSetIjk;
import meshvizxlm.mesh.surfaces.MbSurfaceMeshCurvilinear;
import meshvizxlm.mesh.surfaces.MbSurfaceMeshQuadrangle;
import meshvizxlm.mesh.volumes.MbHexahedronMeshIjk;
import meshvizxlm.mesh.volumes.MbVertexHexahedronMeshIjk;
import meshvizxlm.mesh.volumes.MbVolumeMeshHexahedron;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  class MouseMovedEventCallbackCB extends SoEventCallbackCB
  {
    // Method called each time the mouse is moved in the viewer window
    @Override
    public void invoke(SoEventCallback eventCB)
    {
      if ( m_renderArea.getRenderArea().getInteractionMode() == InteractionMode.NAVIGATION )
        return;

      // Get the picked point (if any)
      // Picking is automatically performed using the event location
      SoPickedPoint pickedPoint = eventCB.getPickedPoint();
      if ( pickedPoint != null )
      {
        // Something has been picked : It could be either an Open Inventor
        // shape like SoCone or a mesh representation. Get detail and check
        // type.
        SoDetail detail = pickedPoint.getDetail();
        if ( detail instanceof MoFaceDetailI )
        {
          m_textDisplaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

          // A face of a mesh representation of a unstructured mesh
          // has been picked. Get detail about the picked face.
          MoFaceDetailI fdetail = (MoFaceDetailI) detail;

          // Get the picked cell and the value at the picked point.
          long cellId = fdetail.getCellIndex();
          double value = fdetail.getValue(pickedPoint.getPoint());

          // Get detail about the picked mesh
          MoMeshDetail mdetail = fdetail.getMeshDetail();
          MeshType meshType = mdetail.getMeshType();
          String colorName = mdetail.getColorScalarSet().getName();

          // Process the detail information retreived by picking,
          // for example...
          display(value, meshType, colorName, cellId);
        }
        else if ( detail instanceof MoFaceDetailIj )
        {
          m_textDisplaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

          // A face of a mesh representation of a structured surface mesh
          // has been picked. Get detail about the picked face.
          MoFaceDetailIj fdetail = (MoFaceDetailIj) detail;

          // Get the picked cell and the value at the picked point.
          long cellI = fdetail.getCellIndexI();
          long cellJ = fdetail.getCellIndexJ();
          double value = fdetail.getValue(pickedPoint.getPoint());

          // Get detail about the picked mesh
          MoMeshDetail mdetail = fdetail.getMeshDetail();
          MeshType meshType = mdetail.getMeshType();

          String colorName = mdetail.getColorScalarSet().getName();

          // Process the detail information retreived by picking,
          // for example...
          display(value, meshType, colorName, cellI, cellJ);
        }
        else if ( detail instanceof MoFaceDetailIjk )
        {
          m_textDisplaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

          // A face of a mesh representation of a unstructured IJK mesh
          // has been picked. Get detail about the picked face.
          MoFaceDetailIjk fdetail = (MoFaceDetailIjk) detail;

          // Get the picked cell and the value at the picked point.
          long cellI = fdetail.getCellIndexI();
          long cellJ = fdetail.getCellIndexJ();
          long cellK = fdetail.getCellIndexK();
          double value = fdetail.getValue(pickedPoint.getPoint());

          // Get detail about the picked mesh
          MoMeshDetail mdetail = fdetail.getMeshDetail();
          MeshType meshType = mdetail.getMeshType();

          String colorName = mdetail.getColorScalarSet().getName();

          // Process the detail information retreived by picking,
          // for example...
          display(value, meshType, colorName, cellI, cellJ, cellK);
        }
      }
      else
      {
        m_textDisplaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    }

    private void display(double value, MeshType meshType, String colorName, long... cell)
    {
      StringBuffer buf = new StringBuffer("cell: ");
      for ( long index : cell )
      {
        buf.append(index);
        buf.append(" ");
      }
      m_indexText.string.setValue(buf.toString());
      m_scalarText.string.setValue("value: " + format(value));

      String mtName;
      switch ( meshType )
      {
      case VOLUME_MESH_UNSTRUCTURED :
        mtName = "Unstructured Volume Mesh";
        break;
      case VOLUME_MESH_HEXAHEDRON_IJK :
        mtName = "Unstructured IJK Hexahedron Mesh";
        break;
      case VOLUME_MESH_VERTEX_HEXAHEDRON_IJK :
        mtName = "Vertex Hexahedron IJK Mesh";
        break;
      case SURFACE_MESH_UNSTRUCTURED :
        mtName = "Quadrangle Mesh";
        break;
      case SURFACE_MESH_CURVILINEAR :
        mtName = "Curvilinear Mesh";
        break;
      default:
        mtName = "";
        break;
      }
      m_meshText.string.setValue(mtName);

      if ( colorName.isEmpty() )
        m_colorText.string.setValue("");
      else
        m_colorText.string.setValue("ColorName: " + colorName);
    }

    private String format(double d)
    {
      if ( d == 0 || (d >= 0.00001 && d < 10000) || (d <= -0.00001 && d > -10000) )
        return decFormat.format(d);
      return scFormat.format(d);
    }
  }

  private static final DecimalFormat scFormat = new DecimalFormat("#.###E0", new DecimalFormatSymbols(Locale.ENGLISH));
  private static final DecimalFormat decFormat =
      new DecimalFormat("#.######", new DecimalFormatSymbols(Locale.ENGLISH));

  private static final int NUM_CELL_I = 10;
  private static final int NUM_CELL_J = 10;
  private static final int NUM_CELL_K = 10;
  private static final String SCALARSET_PER_NODE_NAME = "$ScalarSetX";
  private static final String SCALARSET_PER_CELL_NAME = "$CellId";

  private IViewerExaminer m_renderArea;
  private MbVolumeMeshHexahedron m_meshHexa;
  private MbHexahedronMeshIjk m_meshHexaIjk;
  private MbVertexHexahedronMeshIjk m_meshVertexHexaIjk;
  private MbSurfaceMeshQuadrangle m_meshSurfaceQuadrangle;
  private MbSurfaceMeshCurvilinear m_meshSurfaceCurvilinear;
  private MoMesh m_moMesh;
  private MoPredefinedColorMapping m_colMap;
  private MoScalarSetI m_moScalarSetI;
  private MoScalarSetIj m_moScalarSetIj;
  private MoScalarSetIjk m_moScalarSetIjk;
  private SoSwitch m_displaySwitch;
  private SoSwitch m_textDisplaySwitch;
  private SoText2 m_indexText;
  private SoText2 m_scalarText;
  private SoText2 m_meshText;
  private SoText2 m_colorText;

  public Main()
  {
    double[] min = { 0, 0, 0 };
    double[] max = { 10, 10, 10 };
    MbSampleMeshBuilder meshBuilder = new MbSampleMeshBuilder();

    m_meshHexa = meshBuilder.getMeshHexahedron(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);
    m_meshHexaIjk = meshBuilder.getHexahedronMeshIjk(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);
    m_meshVertexHexaIjk = meshBuilder.getVertexHexahedronMeshIjk(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);
    m_meshSurfaceQuadrangle = meshBuilder.getSurfaceMeshQuadrangle(NUM_CELL_I, NUM_CELL_J, new double[] { 0, 0, 0 },
        new double[] { 10. / NUM_CELL_I, 0, 0 }, new double[] { 0, 10. / NUM_CELL_J, 0 }, null);
    m_meshSurfaceCurvilinear = meshBuilder.getSurfaceMeshCurvilinear(NUM_CELL_I, NUM_CELL_J, new double[] { 0, 0, 0 },
        new double[] { 10. / NUM_CELL_I, 0, 0 }, new double[] { 0, 10. / NUM_CELL_J, 0 });
  }

  @Override
  public void start()
  {
    SoSeparator root = buildSceneGraph();

    m_renderArea = ViewerComponentsFactory.createViewerExaminer();
    m_renderArea.setSceneGraph(root);
    m_renderArea.viewAll();

    // SWING part
    JLabel label = new JLabel("  Mesh: ");
    String[] items =
        new String[] { "Hexahedron", "Hexahedron IJK", "Vertex Hexahedron IJK", "Quadrangle mesh", "Curvilinear mesh" };
    final JComboBox<String> meshBox = new JComboBox<>(items);
    meshBox.setSelectedIndex(0);
    meshBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        switch ( meshBox.getSelectedIndex() )
        {
        case 0 : // Hexahedron
          m_moMesh.setMesh(m_meshHexa);
          MbScalarSetI scalarSet = m_meshHexa.getScalarSet(SCALARSET_PER_NODE_NAME);
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
          m_moScalarSetI.setScalarSet(scalarSet);
          m_displaySwitch.whichChild.setValue(0); // skin
          break;
        case 1 : // hexahedron IJK
          m_moMesh.setMesh(m_meshHexaIjk);
          MbScalarSetI scalarSet2 = m_meshHexaIjk.getScalarSet(SCALARSET_PER_NODE_NAME);
          m_colMap.minValue.setValue((float) scalarSet2.getMin());
          m_colMap.maxValue.setValue((float) scalarSet2.getMax());
          m_moScalarSetI.setScalarSet(scalarSet2);
          m_displaySwitch.whichChild.setValue(0); // skin
          break;
        case 2 : // vertex hexahedron IJK
          m_moMesh.setMesh(m_meshVertexHexaIjk);
          MbScalarSetIjk scalarSet3 = m_meshVertexHexaIjk.getScalarSetIjk(SCALARSET_PER_CELL_NAME);
          m_colMap.minValue.setValue((float) scalarSet3.getMin());
          m_colMap.maxValue.setValue((float) scalarSet3.getMax());
          m_displaySwitch.whichChild.setValue(0); // skin
          break;
        case 3 : // quadrangle mesh
          m_moMesh.setMesh(m_meshSurfaceQuadrangle);
          MbScalarSetI scalarSet4 = m_meshSurfaceQuadrangle.getScalarSet(SCALARSET_PER_NODE_NAME);
          m_colMap.minValue.setValue((float) scalarSet4.getMin());
          m_colMap.maxValue.setValue((float) scalarSet4.getMax());
          m_moScalarSetI.setScalarSet(scalarSet4);
          m_displaySwitch.whichChild.setValue(1); // surface
          break;
        case 4 : // curvilinear mesh
          m_moMesh.setMesh(m_meshSurfaceCurvilinear);
          MbScalarSetIj scalarSetIj = m_meshSurfaceCurvilinear.getScalarSetIj(SCALARSET_PER_NODE_NAME);
          m_colMap.minValue.setValue((float) scalarSetIj.getMin());
          m_colMap.maxValue.setValue((float) scalarSetIj.getMax());
          m_moScalarSetIj.setScalarSet(scalarSetIj);
          m_displaySwitch.whichChild.setValue(1); // surface
          break;
        default:
          break;
        }
      }
    });

    JPanel panel2 = new JPanel();
    panel2.setLayout(new BoxLayout(panel2, BoxLayout.X_AXIS));
    panel2.add(label);
    panel2.add(meshBox);

    final Component component = m_renderArea.getComponent();
    component.setPreferredSize(new Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(panel2, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    m_renderArea.dispose();
  }

  private SoSeparator buildSceneGraph()
  {
    // 3D view
    SoShapeHints sh = new SoShapeHints();
    sh.vertexOrdering.setValue(SoShapeHints.VertexOrderings.CLOCKWISE);

    m_moMesh = new MoMesh();
    m_moMesh.setMesh(m_meshHexa);

    MbScalarSetI scalarSet = m_meshHexa.getScalarSet(SCALARSET_PER_NODE_NAME);

    m_colMap = new MoPredefinedColorMapping();
    m_colMap.minValue.setValue((float) scalarSet.getMin());
    m_colMap.maxValue.setValue((float) scalarSet.getMax());
    m_colMap.predefColorMap.setValue(MoPredefinedColorMapping.PredefColorMapping.STANDARD);

    MoDataBinding dataBinding = new MoDataBinding();
    dataBinding.dataBinding.setValue(MoDataBinding.DataBinding.PER_NODE);

    m_moScalarSetI = new MoScalarSetI();
    m_moScalarSetI.setScalarSet(scalarSet);

    m_moScalarSetIj = new MoScalarSetIj();

    m_moScalarSetIjk = new MoScalarSetIjk();
    m_moScalarSetIjk.setScalarSet(m_meshVertexHexaIjk.getScalarSetIjk(SCALARSET_PER_CELL_NAME));

    MoDrawStyle style = new MoDrawStyle();
    style.displayEdges.setValue(true);

    MoMaterial material = new MoMaterial();
    material.lineColoring.setValue(MoMaterial.ColoringType.COLOR);
    material.lineColor.setValue(0.f, 0.f, 0.f);

    SoLightModel lModel = new SoLightModel();
    lModel.model.setValue(SoLightModel.Models.BASE_COLOR);

    MoMeshSkin skin = new MoMeshSkin();
    skin.colorScalarSetId.setValue(0);

    MoMeshSurface surface = new MoMeshSurface();
    surface.colorScalarSetId.setValue(0);

    m_displaySwitch = new SoSwitch(2);
    {
      m_displaySwitch.addChild(skin);
      m_displaySwitch.addChild(surface);
    }
    m_displaySwitch.whichChild.setValue(0);

    SoEventCallback mouseMovedCb = new SoEventCallback();
    mouseMovedCb.addEventCallback(SoLocation2Event.class, new MouseMovedEventCallbackCB());

    SoSeparator scene3D = new SoSeparator();
    scene3D.setName("Scene_3D");
    {
      scene3D.addChild(sh);
      scene3D.addChild(m_moMesh);
      scene3D.addChild(m_colMap);
      scene3D.addChild(dataBinding);
      scene3D.addChild(m_moScalarSetI);
      scene3D.addChild(m_moScalarSetIj);
      scene3D.addChild(m_moScalarSetIjk);
      scene3D.addChild(style);
      scene3D.addChild(material);
      scene3D.addChild(lModel);
      scene3D.addChild(m_displaySwitch);
      scene3D.addChild(mouseMovedCb);
    }

    // 2D view
    SoOrthographicCamera camera2D = new SoOrthographicCamera();
    camera2D.viewportMapping.setValue(SoCamera.ViewportMappings.LEAVE_ALONE);

    SoSeparator scene2D = new SoSeparator();
    scene2D.setName("Scene_2D");
    {
      scene2D.addChild(camera2D);
      scene2D.addChild(buildTextSceneGraph());
    }

    SoSeparator root = new SoSeparator();
    { // assemble scene graph
      root.addChild(scene3D);
      root.addChild(scene2D);
    }

    return root;
  }

  private SoSwitch buildTextSceneGraph()
  {
    // Text display
    SoSeparator cellTextSep = new SoSeparator();

    SoFont font = new SoFont();
    font.size.setValue(12);

    SoTranslation trans1 = new SoTranslation();
    trans1.translation.setValue(-0.95F, 0.95F, -1.F);

    m_indexText = new SoText2();
    m_indexText.justification.setValue(SoText2.Justifications.LEFT);

    SoTranslation trans2 = new SoTranslation();
    trans2.translation.setValue(0.f, -0.05f, 0);
    m_scalarText = new SoText2();
    m_scalarText.justification.setValue(SoText2.Justifications.LEFT);

    SoSeparator meshTextSep = new SoSeparator();

    SoTranslation trans3 = new SoTranslation();
    trans3.translation.setValue(-0.95f, -0.90f, -1.f);

    m_meshText = new SoText2();
    m_meshText.justification.setValue(SoText2.Justifications.LEFT);
    m_colorText = new SoText2();
    m_colorText.justification.setValue(SoText2.Justifications.LEFT);

    m_textDisplaySwitch = new SoSwitch();
    m_textDisplaySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    SoAnnotation annotation = new SoAnnotation();
    {
      annotation.addChild(m_textDisplaySwitch);
      {
        m_textDisplaySwitch.addChild(cellTextSep);
        {
          cellTextSep.addChild(font);
          cellTextSep.addChild(trans1);
          cellTextSep.addChild(m_indexText);
          cellTextSep.addChild(trans2);
          cellTextSep.addChild(m_scalarText);
        }
        m_textDisplaySwitch.addChild(meshTextSep);
        {
          meshTextSep.addChild(font);
          meshTextSep.addChild(trans3);
          meshTextSep.addChild(m_meshText);
          meshTextSep.addChild(trans2);
          meshTextSep.addChild(m_colorText);
        }
      }
    }

    return m_textDisplaySwitch;
  }

  public static void main(String[] argv)
  {
    Main example = new Main();
    example.demoMain("Picking Example");
  }
}
