package meshvizxlm.mapping.skin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.meshvizxlm.mapping.nodes.*;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterI;
import com.openinventor.meshvizxlm.mesh.cell.MiCellFilterIjk;

import meshvizxlm.mesh.MbSampleMeshBuilder;
import meshvizxlm.mesh.data.MbScalarSetI;
import meshvizxlm.mesh.data.MbScalarSetIjk;
import meshvizxlm.mesh.volumes.MbHexahedronMeshIjk;
import meshvizxlm.mesh.volumes.MbVertexHexahedronMeshIjk;
import meshvizxlm.mesh.volumes.MbVolumeMeshHexahedron;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  class CellFilterIjk implements MiCellFilterIjk
  {
    @Override
    public boolean acceptCell(int i, int j, int k)
    {
      if ( NUM_CELL_I / 3. < i && i <= 2 * NUM_CELL_I / 3. && NUM_CELL_J / 3. < j && j <= 2 * NUM_CELL_J / 3. )
        return false;

      return true;
    }

    @Override
    public long getTimeStamp()
    {
      return 0;
    }
  }

  class CellFilterI implements MiCellFilterI
  {
    @Override
    public boolean acceptCell(long cellIndex)
    {
      int index = (int) cellIndex;
      int ij = index % (NUM_CELL_J * NUM_CELL_I);
      int j = ij / NUM_CELL_I;
      int i = ij % NUM_CELL_I;

      if ( NUM_CELL_I / 3. < i && i <= 2 * NUM_CELL_I / 3. && NUM_CELL_J / 3. < j && j <= 2 * NUM_CELL_J / 3. )
        return false;

      return true;
    }

    @Override
    public long getTimeStamp()
    {
      return 0;
    }
  }

  private static final java.awt.Dimension SLIDER_TEXT_DIM = new java.awt.Dimension(60, 20);

  private static final int NUM_CELL_I = 11;
  private static final int NUM_CELL_J = 15;
  private static final int NUM_CELL_K = 17;

  private static final String SCALARSET_I_NAME = "$Sphere";
  private static final String SCALARSET_IJK_NAME = "$CellId";

  private MbVolumeMeshHexahedron m_meshHexa;
  private MbHexahedronMeshIjk m_meshHexaIjk;
  private MbVertexHexahedronMeshIjk m_meshVertexHexaIjk;

  private MoMesh m_moMesh;
  private MoPredefinedColorMapping m_colMap;
  private MoScalarSetI m_moScalarSetI;
  private MoScalarSetIjk m_moScalarSetIjk;
  private MoCellRanges m_cellRanges;
  private MoMeshSkin m_subskin;
  private SoSwitch m_filterSwitch;
  private MoCellFilter m_moCellFilter;
  private CellFilterI m_cellFilterI;
  private CellFilterIjk m_cellFilterIjk;

  private IViewerExaminer m_renderArea;

  public Main()
  {
    double[] min = { 0, 0, 0 };
    double[] max = { NUM_CELL_I, NUM_CELL_J, NUM_CELL_K };
    MbSampleMeshBuilder meshBuilder = new MbSampleMeshBuilder();

    m_meshHexa = meshBuilder.getMeshHexahedron(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);
    m_meshHexaIjk = meshBuilder.getHexahedronMeshIjk(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);
    m_meshVertexHexaIjk = meshBuilder.getVertexHexahedronMeshIjk(NUM_CELL_I, NUM_CELL_J, NUM_CELL_K, min, max);

    m_cellFilterI = new CellFilterI();
    m_cellFilterIjk = new CellFilterIjk();
  }

  @Override
  public void start()
  {
    SoSeparator root = buildSceneGraph();

    m_renderArea = ViewerComponentsFactory.createViewerExaminer();
    m_renderArea.setSceneGraph(root);
    m_renderArea.viewAll();

    // SWING part
    final JCheckBox filterBox = new JCheckBox("Cell filter");
    filterBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        if ( filterBox.isSelected() )
          m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    JPanel slidersPanel = new JPanel();
    slidersPanel.setBorder(
        new TitledBorder(new EtchedBorder(), "Cell range", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    slidersPanel.setLayout(new GridLayout(0, 1, 0, 0));

    final SliderPanel iMinSliderPanel =
        new SliderPanel(0, NUM_CELL_I * NUM_CELL_J * NUM_CELL_K - 1, (int) m_cellRanges.min.getValueAt(0));
    ((FlowLayout) iMinSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    iMinSliderPanel.addInfoText("I min");
    iMinSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    iMinSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_cellRanges.min.set1Value(0, (long) value);
      }
    });
    slidersPanel.add(iMinSliderPanel);

    final SliderPanel iMaxSliderPanel =
        new SliderPanel(0, NUM_CELL_I * NUM_CELL_J * NUM_CELL_K - 1, (int) m_cellRanges.max.getValueAt(0));
    ((FlowLayout) iMaxSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    iMaxSliderPanel.addInfoText("I max");
    iMaxSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    iMaxSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_cellRanges.max.set1Value(0, (long) value);
      }
    });
    slidersPanel.add(iMaxSliderPanel);

    final SliderPanel jMinSliderPanel = new SliderPanel(0, NUM_CELL_J - 1, 1);
    ((FlowLayout) jMinSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    jMinSliderPanel.addInfoText("J min");
    jMinSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    jMinSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_cellRanges.min.set1Value(1, (long) value);
      }
    });
    jMinSliderPanel.setEnabled(false);
    slidersPanel.add(jMinSliderPanel);

    final SliderPanel jMaxSliderPanel = new SliderPanel(0, NUM_CELL_J - 1, NUM_CELL_J - 2);
    ((FlowLayout) jMaxSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    jMaxSliderPanel.addInfoText("J max");
    jMaxSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    jMaxSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_cellRanges.max.set1Value(1, (long) value);
      }
    });
    jMaxSliderPanel.setEnabled(false);
    slidersPanel.add(jMaxSliderPanel);

    final SliderPanel kMinSliderPanel = new SliderPanel(0, NUM_CELL_K - 1, 1);
    ((FlowLayout) kMinSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    kMinSliderPanel.addInfoText("K min");
    kMinSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    kMinSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_cellRanges.min.set1Value(2, (long) value);
      }
    });
    kMinSliderPanel.setEnabled(false);
    slidersPanel.add(kMinSliderPanel);

    final SliderPanel kMaxSliderPanel = new SliderPanel(0, NUM_CELL_K - 1, NUM_CELL_K - 2);
    ((FlowLayout) kMaxSliderPanel.getLayout()).setAlignment(FlowLayout.LEFT);
    kMaxSliderPanel.addInfoText("K max");
    kMaxSliderPanel.setInfoTextSize(SLIDER_TEXT_DIM);
    kMaxSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        m_cellRanges.max.set1Value(2, (long) value);
      }
    });
    kMaxSliderPanel.setEnabled(false);
    slidersPanel.add(kMaxSliderPanel);

    JPanel meshPanel = new JPanel();
    meshPanel
        .setBorder(new TitledBorder(new EtchedBorder(), "Mesh", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    meshPanel.setLayout(new BorderLayout());
    String[] items = new String[] { "Hexahedron", "Hexahedron IJK", "Vertex Hexahedron IJK" };
    final JComboBox<String> meshBox = new JComboBox<>(items);
    meshBox.setSelectedIndex(0);
    meshBox.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        int selectedIndex = meshBox.getSelectedIndex();

        if ( selectedIndex == 0 )
        { // Hexahedron
          m_moMesh.setMesh(m_meshHexa);
          MbScalarSetI scalarSet = m_meshHexa.getScalarSet(SCALARSET_I_NAME);
          m_colMap.minValue.setValue((float) scalarSet.getMin());
          m_colMap.maxValue.setValue((float) scalarSet.getMax());
          m_moScalarSetI.setScalarSet(scalarSet);
          m_moCellFilter.setCellFilter(m_cellFilterI);

          m_cellRanges.min.setNum(1);
          m_cellRanges.max.setNum(1);

          iMinSliderPanel.setSliderMax(NUM_CELL_I * NUM_CELL_J * NUM_CELL_K - 1);
          updateMinValue(0, NUM_CELL_I * NUM_CELL_J);
          iMaxSliderPanel.setSliderMax(NUM_CELL_I * NUM_CELL_J * NUM_CELL_K - 1);
          updateMaxValue(0, NUM_CELL_I * NUM_CELL_J * (NUM_CELL_K - 1) - 1);
          jMinSliderPanel.setEnabled(false);
          jMaxSliderPanel.setEnabled(false);
          kMinSliderPanel.setEnabled(false);
          kMaxSliderPanel.setEnabled(false);
        }
        else if ( selectedIndex == 1 || selectedIndex == 2 )
        {
          if ( selectedIndex == 1 )
          { // hexahedron IJK
            m_moMesh.setMesh(m_meshHexaIjk);
            MbScalarSetI scalarSet = m_meshHexaIjk.getScalarSet(SCALARSET_I_NAME);
            m_colMap.minValue.setValue((float) scalarSet.getMin());
            m_colMap.maxValue.setValue((float) scalarSet.getMax());
            m_moScalarSetI.setScalarSet(scalarSet);
          }
          else
          { // Vertex hexahedron IJK
            m_moMesh.setMesh(m_meshVertexHexaIjk);
            MbScalarSetIjk scalarSetIjk = m_meshVertexHexaIjk.getScalarSetIjk(SCALARSET_IJK_NAME);
            m_colMap.minValue.setValue((float) scalarSetIjk.getMin());
            m_colMap.maxValue.setValue((float) scalarSetIjk.getMax());
            m_moScalarSetIjk.setScalarSet(scalarSetIjk);
          }
          m_moCellFilter.setCellFilter(m_cellFilterIjk);

          m_cellRanges.min.setNum(3);
          m_cellRanges.max.setNum(3);

          iMinSliderPanel.setSliderMax(NUM_CELL_I - 1);
          updateMinValue(0, 1);
          iMaxSliderPanel.setSliderMax(NUM_CELL_I - 1);
          updateMaxValue(0, NUM_CELL_I - 2);

          jMinSliderPanel.setEnabled(true);
          updateMinValue(1, 1);
          jMaxSliderPanel.setEnabled(true);
          updateMaxValue(1, NUM_CELL_J - 2);

          kMinSliderPanel.setEnabled(true);
          updateMinValue(2, 1);
          kMaxSliderPanel.setEnabled(true);
          updateMaxValue(2, NUM_CELL_K - 2);
        }
      }

      private void updateMinValue(int dim, int value)
      {
        switch ( dim )
        {
        case 0 :
          if ( iMinSliderPanel.getSliderValue() == value )
            m_cellRanges.min.set1Value(0, value);
          else
            iMinSliderPanel.setSliderValue(value);
          break;
        case 1 :
          if ( jMinSliderPanel.getSliderValue() == value )
            m_cellRanges.min.set1Value(1, value);
          else
            jMinSliderPanel.setSliderValue(value);
          break;
        case 2 :
          if ( kMinSliderPanel.getSliderValue() == value )
            m_cellRanges.min.set1Value(2, value);
          else
            kMinSliderPanel.setSliderValue(value);
          break;

        default:
          break;
        }
      }

      private void updateMaxValue(int dim, int value)
      {
        switch ( dim )
        {
        case 0 :
          if ( iMaxSliderPanel.getSliderValue() == value )
            m_cellRanges.max.set1Value(0, value);
          else
            iMaxSliderPanel.setSliderValue(value);
          break;
        case 1 :
          if ( jMaxSliderPanel.getSliderValue() == value )
            m_cellRanges.max.set1Value(1, value);
          else
            jMaxSliderPanel.setSliderValue(value);
          break;
        case 2 :
          if ( kMaxSliderPanel.getSliderValue() == value )
            m_cellRanges.max.set1Value(2, value);
          else
            kMaxSliderPanel.setSliderValue(value);
          break;

        default:
          break;
        }
      }
    });
    meshPanel.add(meshBox, BorderLayout.CENTER);

    JPanel optionsPanel = new JPanel(new BorderLayout());
    optionsPanel.add(filterBox, BorderLayout.NORTH);
    optionsPanel.add(slidersPanel, BorderLayout.CENTER);
    optionsPanel.add(meshPanel, BorderLayout.SOUTH);

    final Component component = m_renderArea.getComponent();
    component.setPreferredSize(new Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(optionsPanel, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    m_renderArea.dispose();
  }

  private SoSeparator buildSceneGraph()
  {
    SoShapeHints sh = new SoShapeHints();
    sh.vertexOrdering.setValue(SoShapeHints.VertexOrderings.CLOCKWISE);

    m_moMesh = new MoMesh();
    m_moMesh.setMesh(m_meshHexa);

    MbScalarSetI scalarSet = m_meshHexa.getScalarSet(SCALARSET_I_NAME);

    m_colMap = new MoPredefinedColorMapping();
    m_colMap.minValue.setValue((float) scalarSet.getMin());
    m_colMap.maxValue.setValue((float) scalarSet.getMax());
    m_colMap.predefColorMap.setValue(MoPredefinedColorMapping.PredefColorMapping.STANDARD);

    MoDataBinding dataBinding = new MoDataBinding();
    dataBinding.dataBinding.setValue(MoDataBinding.DataBinding.PER_NODE);

    m_moScalarSetI = new MoScalarSetI();
    m_moScalarSetI.setScalarSet(scalarSet);

    m_moScalarSetIjk = new MoScalarSetIjk();

    m_cellRanges = new MoCellRanges();

    SoLightModel lModel = new SoLightModel();
    lModel.model.setValue(SoLightModel.Models.BASE_COLOR);

    m_filterSwitch = new SoSwitch();
    m_filterSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    m_moCellFilter = new MoCellFilter();
    m_moCellFilter.setCellFilter(m_cellFilterI);
    {
      m_filterSwitch.addChild(m_moCellFilter);
    }

    // whole skin
    MoDrawStyle style = new MoDrawStyle();
    style.displayFaces.setValue(false);
    style.displayEdges.setValue(true);

    MoMeshSkin skin = new MoMeshSkin();
    skin.colorScalarSetId.setValue(0);

    SoSeparator skinSep = new SoSeparator();
    {
      skinSep.addChild(style);
      skinSep.addChild(skin);
    }

    // sub-skin
    m_subskin = new MoMeshSkin();
    m_cellRanges.min.set1Value(0, NUM_CELL_I * NUM_CELL_J);
    m_cellRanges.max.set1Value(0, NUM_CELL_I * NUM_CELL_J * (NUM_CELL_K - 1) - 1);
    m_subskin.colorScalarSetId.setValue(0);

    MoMesh subskinMesh = new MoMesh();
    subskinMesh.connectFrom(m_subskin);

    SoSeparator subskinSep = new SoSeparator();
    {
      subskinSep.addChild(m_cellRanges);
      subskinSep.addChild(m_subskin);
    }

    SoSeparator root = new SoSeparator();
    {
      root.addChild(sh);
      root.addChild(m_moMesh);
      root.addChild(m_colMap);
      root.addChild(dataBinding);
      root.addChild(m_moScalarSetI);
      root.addChild(m_moScalarSetIjk);
      root.addChild(lModel);
      root.addChild(m_filterSwitch);
      root.addChild(skinSep);
      root.addChild(subskinSep);
    }

    return root;
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Skin demo");
  }

}
