package meshvizxlm.mesh.data;

import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetI;

public class MbScalarSetI extends MbDataSet implements MiScalardSetI
{
  protected static int s_numInstance = 0;
  private double[] m_scalars;
  private double m_min;
  private double m_max;

  public MbScalarSetI()
  {
    this.m_name = "MbScalarSet_#" + s_numInstance;
    s_numInstance++;
  }

  public MbScalarSetI(double[] scalars)
  {
    this();

    m_scalars = scalars;
    updateMinMax();
  }

  public MbScalarSetI(double[] scalars, String name, DataBinding binding)
  {
    super(name, binding);

    m_scalars = scalars;
    updateMinMax();
  }

  public void assign(double[] scalars)
  {
    m_scalars = scalars;
    updateMinMax();
    touch();
  }

  public int getSize()
  {
    return this.m_scalars.length;
  }

  @Override
  public double get(long i)
  {
    return this.m_scalars[(int) i];
  }

  public double getMin()
  {
    return m_min;
  }

  public double getMax()
  {
    return m_max;
  }

  private void updateMinMax()
  {
    m_min = Double.POSITIVE_INFINITY;
    m_max = Double.NEGATIVE_INFINITY;
    for ( double d : m_scalars )
    {
      if ( m_min > d )
        m_min = d;
      if ( m_max < d )
        m_max = d;
    }
  }

}
