package meshvizxlm.mesh.data;

import com.openinventor.meshvizxlm.mesh.StorageLayoutIJ;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiScalardSetIj;

import meshvizxlm.mesh.MbIjToI;

public class MbScalarSetIj extends MbDataSet implements MiScalardSetIj
{
  protected static int s_numInstance = 0;

  private double[] m_scalars;
  private double m_min;
  private double m_max;
  private boolean m_isMinMaxUpToDate;
  protected MbIjToI m_adaptor;
  protected int m_numI;
  protected int m_numJ;

  public MbScalarSetIj(int numI, int numJ, String name, DataBinding binding)
  {
    super(name, binding);

    s_numInstance++;

    m_adaptor = new MbIjToI(numI);
    m_numI = numI;
    m_numJ = numJ;

    m_scalars = new double[m_numI * m_numJ];
    m_isMinMaxUpToDate = false;
  }

  public MbScalarSetIj(int numI, int numJ)
  {
    super();

    m_name = "MbScalarSet_#" + s_numInstance;
    s_numInstance++;

    m_adaptor = new MbIjToI(numI);
    m_numI = numI;
    m_numJ = numJ;

    m_scalars = new double[m_numI * m_numJ];
    m_isMinMaxUpToDate = false;
  }

  @Override
  public double get(long i, long j)
  {
    return m_scalars[(int) m_adaptor.getI(i, j)];
  }

  @Override
  public StorageLayoutIJ getStorageLayout()
  {
    return StorageLayoutIJ.JI;
  }

  public void set(int i, int j, double data)
  {
    if ( i < m_numI && j < m_numJ )
    {
      m_scalars[(int) m_adaptor.getI(i, j)] = data;
      m_isMinMaxUpToDate = false;
      touch();
    }
  }

  public int[] getSize(int[] size)
  {
    if ( size == null )
      size = new int[2];
    size[0] = m_numI;
    size[1] = m_numJ;

    return size;
  }

  public void setSize(int numI, int numJ)
  {
    m_adaptor.setNumI(numI);

    m_numI = numI;
    m_numJ = numJ;

    m_scalars = new double[m_numI * m_numJ];
    m_isMinMaxUpToDate = false;
    touch();
  }

  public double getMin()
  {
    updateMinMax();
    return m_min;
  }

  public double getMax()
  {
    updateMinMax();
    return m_max;
  }

  private void updateMinMax()
  {
    if ( !m_isMinMaxUpToDate )
    {
      m_min = Double.POSITIVE_INFINITY;
      m_max = Double.NEGATIVE_INFINITY;
      for ( double d : m_scalars )
      {
        if ( m_min > d )
          m_min = d;
        if ( m_max < d )
          m_max = d;
      }
      m_isMinMaxUpToDate = true;
    }
  }
}
