package meshvizxlm.mesh.data;

import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiVec3dSetI;

public class MbVec3SetI extends MbDataSet implements MiVec3dSetI
{

  protected static int s_numInstance = 0;
  protected double[] m_xArray;
  protected double[] m_yArray;
  protected double[] m_zArray;

  protected MbVec3SetI()
  {
    this.m_name = "MbVec3Set_#" + s_numInstance;
    s_numInstance++;
  }

  public MbVec3SetI(double[] xArray, double[] yArray, double[] zArray)
  {
    this();

    m_xArray = xArray;
    m_yArray = yArray;
    m_zArray = zArray;
  }

  public MbVec3SetI(double[] xArray, double[] yArray, double[] zArray, String name, DataBinding binding)
  {
    super(name, binding);

    m_xArray = xArray;
    m_yArray = yArray;
    m_zArray = zArray;
  }

  public int getSize()
  {
    return m_xArray.length;
  }

  @Override
  public double[] get(long i)
  {
    int index = (int) i;
    return new double[] { m_xArray[index], m_yArray[index], m_zArray[index] };
  }

}
