package meshvizxlm.mesh.data;

import com.openinventor.meshvizxlm.mesh.StorageLayoutIJ;
import com.openinventor.meshvizxlm.mesh.data.DataBinding;
import com.openinventor.meshvizxlm.mesh.data.MiVec3dSetIj;

import meshvizxlm.mesh.MbIjToI;

public class MbVec3SetIj extends MbDataSet implements MiVec3dSetIj
{
  protected static int s_numInstance = 0;

  private double[] m_xArray;
  private double[] m_yArray;
  private double[] m_zArray;
  protected MbIjToI m_adaptor;
  protected int m_numI;
  protected int m_numJ;

  public MbVec3SetIj(int numI, int numJ, String name, DataBinding binding)
  {
    super(name, binding);

    s_numInstance++;

    m_adaptor = new MbIjToI(numI);
    m_numI = numI;
    m_numJ = numJ;

    final int size = m_numI * m_numJ;
    m_xArray = new double[size];
    m_yArray = new double[size];
    m_zArray = new double[size];
  }

  public MbVec3SetIj(int numI, int numJ)
  {
    super();

    m_name = "MbVec3Set_#" + s_numInstance;
    s_numInstance++;

    m_adaptor = new MbIjToI(numI);
    m_numI = numI;
    m_numJ = numJ;

    final int size = m_numI * m_numJ;
    m_xArray = new double[size];
    m_yArray = new double[size];
    m_zArray = new double[size];
  }

  @Override
  public double[] get(long i, long j)
  {
    int index = (int) m_adaptor.getI(i, j);
    return new double[] { m_xArray[index], m_yArray[index], m_zArray[index] };
  }

  @Override
  public StorageLayoutIJ getStorageLayout()
  {
    return StorageLayoutIJ.UNKNOWN;
  }

  public void set(int i, int j, double x, double y, double z)
  {
    if ( i < m_numI && j < m_numJ )
    {
      int index = (int) m_adaptor.getI(i, j);
      m_xArray[index] = x;
      m_yArray[index] = y;
      m_zArray[index] = z;
      touch();
    }
  }

  public int[] getSize(int[] size)
  {
    if ( size == null )
      size = new int[2];
    size[0] = m_numI;
    size[1] = m_numJ;

    return size;
  }

  public void setSize(int numI, int numJ)
  {
    m_adaptor.setNumI(numI);

    m_numI = numI;
    m_numJ = numJ;

    final int size = m_numI * m_numJ;
    m_xArray = new double[size];
    m_yArray = new double[size];
    m_zArray = new double[size];
    touch();
  }

}
