package meshvizxlm.mesh.geometry;

import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryIj;

import meshvizxlm.mesh.MbIjToI;

public class MbGeometryIj extends MbGeometry implements MiGeometryIj
{

  private double[] m_xArray;
  private double[] m_yArray;
  private double[] m_zArray;
  private MbIjToI m_adaptor;

  public MbGeometryIj(int numNodesI)
  {
    super();

    m_adaptor = new MbIjToI(numNodesI);
  }

  public void assign(double[] xArray, double[] yArray, double[] zArray)
  {
    m_xArray = xArray;
    m_yArray = yArray;
    m_zArray = zArray;

    touch();
  }

  @Override
  public double[] getCoord(long i, long j)
  {
    int index = (int) m_adaptor.getI(i, j);
    return new double[] { m_xArray[index], m_yArray[index], m_zArray[index] };
  }

  @Override
  public String getNodeName(long i, long j)
  {
    return "(" + i + "," + j + ")";
  }
}
