package meshvizxlm.mesh.topology;

import java.util.BitSet;
import java.util.List;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.cell.MiVolumeCell;
import com.openinventor.meshvizxlm.mesh.topology.MiVolumeTopologyExplicitI;

public abstract class MbTopologyI<Cell extends MiVolumeCell> implements MiVolumeTopologyExplicitI<Cell>
{

  protected long m_timeStamp;
  protected BitSet m_deadCells;

  public MbTopologyI()
  {
    this.m_timeStamp = MxTimeStamp.getTimeStamp();
    m_deadCells = new BitSet(0);
  }

  @Override
  public long getTimeStamp()
  {
    return this.m_timeStamp;
  }

  public void touch()
  {
    this.m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  @Override
  public boolean hasDeadCells()
  {
    return !m_deadCells.isEmpty();
  }

  @Override
  public boolean isDead(long i)
  {
    return m_deadCells.get((int) i);
  }

  @Override
  public String getCellName(long i)
  {
    return String.valueOf(i);
  }

  public void assignDeadFlags(boolean[] flags)
  {
    int i = 0;
    m_deadCells = new BitSet(flags.length);
    for ( boolean flag : flags )
    {
      m_deadCells.set(i, flag);
      i++;
    }
    m_timeStamp = MxTimeStamp.getTimeStamp();
  }

  public void assign(List<Integer> nodeIds)
  {
    NodeIdProvider provider = new NodeIdList(nodeIds);
    assign(provider);
  }

  public void assign(int... nodeIds)
  {
    NodeIdProvider provider = new NodeIdArray(nodeIds);
    assign(provider);
  }

  protected abstract void assign(NodeIdProvider provider);
}
