package meshvizxlm.mesh.topology;

import java.util.BitSet;

import com.openinventor.meshvizxlm.MxTimeStamp;
import com.openinventor.meshvizxlm.mesh.StorageLayoutIJK;
import com.openinventor.meshvizxlm.mesh.topology.MiTopologyIjk;

import meshvizxlm.mesh.MbIjkToI;

/**
 * List of volume cells.
 * <p>
 * An implementation for a IJK implicit mesh topology.
 */
public class MbTopologyIjk extends MbTopology implements MiTopologyIjk
{

  protected MbIjkToI m_adaptor;
  protected int m_numI;
  protected int m_numJ;
  protected int m_numK;
  protected boolean m_hasDeadCells;

  public MbTopologyIjk(int numCellI, int numCellJ, int numCellK, StorageLayoutIJK storageLayout)
  {
    m_adaptor = new MbIjkToI(numCellI, numCellJ, numCellK, storageLayout);
    m_numI = numCellI;
    m_numJ = numCellJ;
    m_numK = numCellK;
    m_deadCells = new BitSet(numCellI * numCellJ * numCellK);
    m_hasDeadCells = false;
  }

  public MbIjkToI getAdaptor()
  {
    return m_adaptor;
  }

  @Override
  public int getNumCellsI()
  {
    return m_numI;
  }

  @Override
  public int getNumCellsJ()
  {
    return m_numJ;
  }

  @Override
  public int getNumCellsK()
  {
    return m_numK;
  }

  @Override
  public boolean hasDeadCells()
  {
    return m_hasDeadCells;
  }

  @Override
  public boolean isDead(int i, int j, int k)
  {
    return m_deadCells.get((int) m_adaptor.getI(i, j, k));
  }

  @Override
  public String getCellName(int i, int j, int k)
  {
    return "(" + i + "," + j + "," + k + ")";
  }

  /**
   * Set the dead flag of cell (i,j,k).
   *
   * @param i
   * @param j
   * @param k
   * @param isDead
   */
  public void setDeadFlag(int i, int j, int k, boolean isDead)
  {
    if ( i < m_numI && j < m_numJ && k < m_numK )
    {
      m_deadCells.set((int) m_adaptor.getI(i, j, k), isDead);
      m_hasDeadCells |= isDead;
      m_timeStamp = MxTimeStamp.getTimeStamp();
    }
  }

}
