package meshvizxlm.mesh.volumes;

import com.openinventor.meshvizxlm.mesh.MiVolumeMeshVertexHexahedronIjk;
import com.openinventor.meshvizxlm.mesh.geometry.MiGeometryHexahedronIjk;
import com.openinventor.meshvizxlm.mesh.topology.MiTopologyIjk;

import meshvizxlm.mesh.geometry.MbGeometryHexahedronIjk;

public class MbVertexHexahedronMeshIjk extends MbMeshIjk
    implements MiVolumeMeshVertexHexahedronIjk<MiTopologyIjk, MiGeometryHexahedronIjk>
{

  private MiTopologyIjk m_topology;
  private MbGeometryHexahedronIjk m_geometry;

  public MbVertexHexahedronMeshIjk(MbHexahedronMeshIjk hexaIjkMesh)
  {
    super();

    m_topology = hexaIjkMesh.getTopology();
    m_geometry = new MbGeometryHexahedronIjk(hexaIjkMesh);
  }

  @Override
  public MiTopologyIjk getTopology()
  {
    return m_topology;
  }

  @Override
  public MiGeometryHexahedronIjk getGeometry()
  {
    return m_geometry;
  }

  public void touch()
  {
    m_geometry.touch();
  }
}
