package meshvizxlm.mesh.volumes;

import java.util.List;

import meshvizxlm.mesh.cell.MbHexahedronCell;
import meshvizxlm.mesh.topology.MbHexahedronCellsSet;

import com.openinventor.meshvizxlm.mesh.topology.MiVolumeTopologyExplicitI;

public class MbVolumeMeshHexahedron extends MbVolumeMeshUnstructured<MbHexahedronCell>
{

  protected MbHexahedronCellsSet m_topology;

  public MbVolumeMeshHexahedron(double[] xArray, double[] yArray, double[] zArray, List<Integer> nodeIds)
  {
    super(xArray, yArray, zArray);

    this.m_topology = new MbHexahedronCellsSet();
    setTopology(nodeIds);
  }

  public MbVolumeMeshHexahedron(double[] xArray, double[] yArray, double[] zArray, int... nodeIds)
  {
    super(xArray, yArray, zArray);

    this.m_topology = new MbHexahedronCellsSet();
    setTopology(nodeIds);
  }

  @Override
  public MiVolumeTopologyExplicitI<MbHexahedronCell> getTopology()
  {
    return this.m_topology;
  }

  public void setTopology(List<Integer> nodeIds)
  {
    this.m_topology.assign(nodeIds);
  }

  public void setTopology(int... nodeIds)
  {
    this.m_topology.assign(nodeIds);
  }

  /**
   * Defines dead cells
   */
  public void setDeadCells(boolean[] flags)
  {
    m_topology.assignDeadFlags(flags);
  }

}
