package meshvizxlm.mesh.volumes;

import java.util.List;

import meshvizxlm.mesh.cell.MbWedgeCell;
import meshvizxlm.mesh.topology.MbWedgeCellsSet;

import com.openinventor.meshvizxlm.mesh.topology.MiVolumeTopologyExplicitI;

public class MbVolumeMeshWedge extends MbVolumeMeshUnstructured<MbWedgeCell>
{

  protected MbWedgeCellsSet m_topology;

  public MbVolumeMeshWedge(double[] xArray, double[] yArray, double[] zArray, List<Integer> nodeIds)
  {
    super(xArray, yArray, zArray);

    this.m_topology = new MbWedgeCellsSet();
    setTopology(nodeIds);
  }

  public MbVolumeMeshWedge(double[] xArray, double[] yArray, double[] zArray, int... nodeIds)
  {
    super(xArray, yArray, zArray);

    this.m_topology = new MbWedgeCellsSet();
    setTopology(nodeIds);
  }

  @Override
  public MiVolumeTopologyExplicitI<MbWedgeCell> getTopology()
  {
    return this.m_topology;
  }

  public void setTopology(List<Integer> nodeIds)
  {
    this.m_topology.assign(nodeIds);
  }

  public void setTopology(int... nodeIds)
  {
    this.m_topology.assign(nodeIds);
  }

}
