import { Component, OnInit, AfterViewInit } from '@angular/core';

/// <reference path="../../../libs/RemoteVizClient/RemoteVizClient.d.ts" />
import RemoteVizRenderArea = require("../../../libs/RemoteVizClient/RemoteVizClient");

import 'jquery';

@Component({
  selector: 'app-remoteviz',
  templateUrl: './remoteviz.component.html',
  styleUrls: ['./remoteviz.component.css']
})
export class RemotevizComponent implements AfterViewInit {

  theRenderArea: RemoteVizRenderArea = null;
  metrics: string = '';
  color: boolean = false;
  dataSize: number = 0;
  fps: number = 0;
  serviceMessage: string = '';
  currentbandwidth: number = 0;
  currentfps: number = 0;
  pendingNetworkCalibration: boolean = false;

  private _cwidth: number = 640;

  public get cwidth(): number {
    return this._cwidth;
  }

  public set cwidth(width: number) {
    if (width) {
      this._cwidth = width;
      this.theRenderArea.resizeRenderAreaContainer(this.cwidth, this.cheight);
    }
  }

  private _cheight: number = 480;

  public get cheight(): number {
    return this._cheight;
  }

  public set cheight(height: number) {
    if (height) {
      this._cheight = height;
      this.theRenderArea.resizeRenderAreaContainer(this.cwidth, this.cheight);
    }
  }

  private _rwidth: number = 640;

  public get rwidth(): number {
    return this._rwidth;
  }

  public set rwidth(width: number) {
    if (width) {
      this._rwidth = width;
      this.theRenderArea.sendMessage("WIDTH " + this.rwidth);
    }
  }

  private _rheight: number = 480;

  public get rheight(): number {
    return this._rheight;
  }

  public set rheight(height: number) {
    if (height) {
      this._rheight = height;
      this.theRenderArea.sendMessage("HEIGHT " + this.rheight);
    }
  }

  private _encodingPolicy: string = "KeepFrameQuality";

  public get encodingPolicy(): string {
    return this._encodingPolicy;
  }

  public set encodingPolicy(value: string) {
    this._encodingPolicy = value;
    this.theRenderArea.sendMessage("POLICY " + this._encodingPolicy);
  }


  private _bandwidth: number = 1;

  public get bandwidth(): number {
    return this._bandwidth;
  }

  public set bandwidth(value: number) {
    this._bandwidth = value;
    this.theRenderArea.sendMessage("BANDWIDTH " + Math.round(this._bandwidth * 1024 * 1024 * 8));
  }

  constructor() { }

  ngAfterViewInit() {
    this.init();
  }

  receivedFrame(args) {
    // call when receiving a new frame from the service
    const frameId = args[0];
    const frameLength = args[1];
    const message = args[2];
    this.dataSize += frameLength;
  }

  decodedFrame(args) {
    // call when decoding a new frame
    const frameId = args[0];
    const isLossless = args[1];
    const message = args[2];
    this.fps += 1;
  }

  service(event) {
    this.serviceMessage = event[0];
    switch (this.serviceMessage) {
      case "startNetworkCalibration": {
        this.pendingNetworkCalibration = true;
        break;
      }
      case "finishedNetworkCalibration": {
        this.pendingNetworkCalibration = false;
        break;
      }
    }
  }

  measurebandwithandfps() {
    this.currentbandwidth = parseFloat((this.dataSize / (1000 * 1000)).toFixed(2));
    this.currentfps = this.fps;
    this.dataSize = 0;
    this.fps = 0;
  }

  init() {
    // Initialization of the renderArea. "TheDiv" refers to the id of the div.
    this.theRenderArea = new RemoteVizRenderArea("TheDiv", this.cwidth, this.cheight);
    // add a listener on the receivedFrame event.
    this.theRenderArea.addReceivedFrameListener(this.receivedFrame.bind(this));
    // add a listener on the decodedFrame event.
    this.theRenderArea.addDecodedFrameListener(this.decodedFrame.bind(this));
    // Listen start and stop bandwidth calibration events to display or hide the loader.
    this.theRenderArea.addServiceListener(this.service.bind(this));
    // Connects to the service. The IP address and the port refer to those of the service (see main.cpp). "Model" refers to the name of the requested renderArea.
    this.theRenderArea.connectTo("ws://127.0.0.1:8080/Model");

    // Calls a or executes a code snippet repeatedly to refresh the bandwidth and the fps
    window.setInterval(this.measurebandwithandfps.bind(this), 1000);
  }

}
