package remoteviz.connectionmanagement.connectionmanagementrenderingservice;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.remoteviz.rendering.Client;
import com.openinventor.remoteviz.rendering.ConnectionParameters;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaListener;
import com.openinventor.remoteviz.rendering.Service;
import com.openinventor.remoteviz.rendering.ServiceListener;
import com.openinventor.remoteviz.rendering.ServiceSettings;
import com.openinventor.remoteviz.rendering.RenderAreaHardware;

public class ConnectionManagementService
{

  private static boolean running = true;

  private static int maxConnection = 3;

  /**
   * @param args
   * @throws InterruptedException
   */
  public static void main(String[] args)
  {
    // Enable Open Inventor multithreading support
    SoPreferences.setValue("OIV_MULTITHREAD", "1");

    // Default value for service IP address
    String serviceIPaddress = "127.0.0.1";
    // Default value for service port
    short servicePort = 8080;

    // Use passed values for the service IP address and port
    if ( args.length == 2 )
    {
      serviceIPaddress = args[0];
      servicePort = Short.parseShort(args[1]);
    }

    // Instantiate a service settings class
    ServiceSettings settings = new ServiceSettings();
    // set the IP address used by the service
    settings.setIP(serviceIPaddress);
    // set the port used by the service
    settings.setPort(servicePort);

    // Add a ConnectionManagementServiceListener class as listener
    Service.instance().addListener(new ConnectionManagementServiceListener());

    // To use an Open Inventor extension with RemoteViz, uncomment the following
    // line and set the extension name.
    // settings.setUsedExtensions(ServiceSettings.Extensions.VOLUMEVIZLDM);

    // Open the service by using the settings
    if ( Service.instance().open(settings) )
    {
      Runtime.getRuntime().addShutdownHook(new Thread()
      {
        @Override
        public void run()
        {
          running = false;
        }
      });

      System.out.println("The ConnectionManagement Rendering Service is running. Press Ctrl + C to stop.");
      try
      {
        // Main loop
        while ( running )
        {
          Service.instance().dispatch();
          Thread.sleep(1);
        }
      }
      catch (InterruptedException ex)
      {}
      finally
      {
        // Close the service
        Service.instance().close();
      }
    }

  }

  public static class ConnectionManagementServiceListener extends ServiceListener
  {
    private boolean signin(String login, String password)
    {
      /* Check if the login and the password are correct */
    
      if ( login.equals("user") && password.equals("password") )
      {
        return true;
      }
      else
      {
        return false;
      }
    }
    
    private boolean accept(ConnectionParameters parameters)
    {
      /*
       * These parameters refer to the GET parameters in the service URI. (see
       * index.html)
       */
      String login = parameters.getValue("login");
      String password = parameters.getValue("password");
    
      if ( (Service.instance().getRenderArea(0) == null
          || Service.instance().getRenderArea(0).getNumConnections() < maxConnection) && signin(login, password) )
      {
        return true;
      }
      else
      {
        return false;
      }
    }
    
    @Override
    public boolean onPendingCreateRenderArea(String renderAreaId, int[] size, RenderAreaHardware renderAreaHardware, Client client,
        ConnectionParameters parameters)
    {
      /*
       * Triggered when a connection is pending and the requested renderArea
       * doesn't exist.
       */
    
      return accept(parameters); // Check if the user is accepted
    }
    
    @Override
    public boolean onPendingShareRenderArea(RenderArea renderArea, Client client, ConnectionParameters parameters)
    {
      /*
       * Triggered when a connection is pending and the requested renderArea
       * exists.
       */
    
      return accept(parameters); // Check if the user is accepted
    }
    
    @Override
    public void onInstantiatedRenderArea(RenderArea renderArea)
    {
      RenderAreaListener renderAreaListener = new RenderAreaListener();
      renderArea.addListener(renderAreaListener);
      renderArea.getTouchManager().addDefaultRecognizers();
    
      SceneExaminer sceneExaminer = new SceneExaminer();
      sceneExaminer.addChild(new SoGradientBackground());
      sceneExaminer.addChild(new SoCone());
    
      renderArea.getSceneManager().setSceneGraph(sceneExaminer);
      sceneExaminer.viewAll(renderArea.getSceneManager().getViewportRegion());
    }
  }
}
