package remoteviz.hellocone.helloconerenderingservice;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaListener;
import com.openinventor.remoteviz.rendering.Service;
import com.openinventor.remoteviz.rendering.ServiceListener;
import com.openinventor.remoteviz.rendering.ServiceSettings;

public class HelloConeService
{

  private static boolean running = true;

  /**
   * @param args
   * @throws InterruptedException
   */
  public static void main(String[] args)
  {
    // Enable Open Inventor multithreading support
    SoPreferences.setValue("OIV_MULTITHREAD", "1");

    // Default value for service IP address
    String serviceIPaddress = "127.0.0.1";
    // Default value for service port
    short servicePort = 8080;

    // Use passed values for the service IP address and port
    if ( args.length == 2 )
    {
      serviceIPaddress = args[0];
      servicePort = Short.parseShort(args[1]);
    }

    // Instantiate a service settings class
    ServiceSettings settings = new ServiceSettings();
    // set the IP address used by the service
    settings.setIP(serviceIPaddress);
    // set the port used by the service
    settings.setPort(servicePort);

    // Add a HelloConeServiceListener class as listener
    Service.instance().addListener(new HelloConeServiceListener());

    // To use an Open Inventor extension with RemoteViz, uncomment the following
    // line and set the extension name.
    // settings.setUsedExtensions(ServiceSettings.Extensions.VOLUMEVIZLDM);

    // Open the service by using the settings
    if ( Service.instance().open(settings) )
    {
      Runtime.getRuntime().addShutdownHook(new Thread()
      {
        @Override
        public void run()
        {
          running = false;
        }
      });

      System.out.println("The HelloCone Rendering Service is running. Press Ctrl + C to stop.");
      try
      {
        // Main loop
        while ( running )
        {
          Service.instance().dispatch();
          Thread.sleep(1);
        }
      }
      catch (InterruptedException ex)
      {}
      finally
      {
        // Close the service
        Service.instance().close();
      }
    }

  }

  public static class HelloConeServiceListener extends ServiceListener
  {
    @Override
    public void onInstantiatedRenderArea(RenderArea renderArea)
    {
      RenderAreaListener renderAreaListener = new RenderAreaListener();
      renderArea.addListener(renderAreaListener);
      renderArea.getTouchManager().addDefaultRecognizers();

      SceneExaminer sceneExaminer = new SceneExaminer();
      sceneExaminer.addChild(new SoGradientBackground());
      sceneExaminer.addChild(new SoCone());

      renderArea.getSceneManager().setSceneGraph(sceneExaminer);
      sceneExaminer.viewAll(renderArea.getSceneManager().getViewportRegion());
    }
  }
}
