package remoteviz.inventorapplication.inventorapplicationrenderingservice;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas.RenderAreaExaminer;
import com.openinventor.remoteviz.rendering.Service;
import com.openinventor.remoteviz.rendering.ServiceSettings;

public class InventorApplicationMain extends Panel
{

  private static final short HEIGHT = 480;
  private static final short WIDTH = 640;

  public InventorApplicationMain()
  {
    RenderAreaExaminer renderArea = new RenderAreaExaminer();
    renderArea.setSceneGraph(new SoCone());
    renderArea.viewAll(new SbViewportRegion(WIDTH, HEIGHT));

    // Keep the root for onInstantiatedRenderArea callback
    InventorApplicationService.root = renderArea.getRootSceneGraph();

    setLayout(new BorderLayout());
    add(renderArea);
  }

  public static void main(String[] args)
  {
    // Enable Open Inventor multithreading support
    SoPreferences.setValue("OIV_MULTITHREAD", "1");

    // Default value for service IP address
    String serviceIPaddress = "127.0.0.1";
    // Default value for service port
    short servicePort = 8080;

    // Use passed values for the service IP address and port
    if ( args.length == 2 )
    {
      serviceIPaddress = args[0];
      servicePort = Short.parseShort(args[1]);
    }

    // Instantiate a service settings class
    ServiceSettings settings = new ServiceSettings();
    // set the IP address used by the service
    settings.setIP(serviceIPaddress);
    // set the port used by the service
    settings.setPort(servicePort);
    // set the run mode used by the service
    settings.setRunMode(ServiceSettings.RunModes.INVENTOR_APPLICATION);

    // Add a BasicHTMLGuiService class as listener
    Service.instance().addListener(new InventorApplicationService());

    // Create RenderAreaExaminer and scene graph
    InventorApplicationMain demo = new InventorApplicationMain();

    // Open the RemoteViz service by using the settings
    if ( Service.instance().open(settings) )
    {
      final Frame frame = new Frame("Open Inventor SoCone, using RenderAreaExaminer");
      frame.add(demo);
      frame.setSize(WIDTH, HEIGHT);
      frame.addWindowListener(new WindowAdapter()
      {
        @Override
        public void windowClosing(WindowEvent e)
        {
          // Close the RemoteViz service
          Service.instance().close();
          System.exit(0);
        }
      });
      frame.setVisible(true);

      System.out.println("The InventorApplication Rendering Service is running.");

    }
  }

}
