    
    var renderArea = null;
    var ip = "127.0.0.1";
    var port = 8080;
	
    window.addEventListener('resize', resizeOrUpdateOrientation);

    window.onload = function () 
    {
        /* add listeners on the UI */
        
        $("#select-market").change(function(){changeMarket();});
        $("#select-session").change(function(){changeSession();});
        $("#select-model").change(function(){changeModel();});
        $("#checkbox-picking").change(function(){changePickingMode();});
        
        $(".trigger").click(function()
        {
            $(".panel").toggle("fast");
            $(".trigger").hide();
            return false;
        });
        
        $(".trigger-r").click(function()
        {
            $(".panel").toggle("fast");
            $(".trigger").show();
            return false;
        });
        
        // reset lists
        $('#select-model option').remove();
        $('#select-model').selectmenu('refresh', true);
        $('#select-market').find('option:selected').removeAttr('selected');
        $('#select-market').attr('selectedIndex', -1).selectmenu('refresh', true); 

        // load the first session
        changeSession();
    };

    // messages received from the service
    function messageReceive(message)
    {
        /* UI synchronization between the clients shared the same session */
        
        var elem = message.split(' ');
        if (elem[0] == "pick"){ // picking mode
            if (elem[1] == "on"){
                $("#picking-img").attr('src','resources/Images/hand.png');
                $("#checkbox-picking").attr('checked',true).checkboxradio("refresh");
            }
            else
            {
                $("#picking-img").attr('src','resources/Images/pointer.png');
                $("#checkbox-picking").attr('checked',false).checkboxradio("refresh");
            }
        }
        else if (elem[0] == "clients")
        { // number of connected clients
            $("#clients").html(elem[1] + " connected client(s)");
        }
        else if (elem[0] == "open")
        { // change model
            var file = elem[1].split('/');
            $("#select-market").val(file[0] + '/' + file[1]);
            
            var select = document.getElementById("select-model");
            select.options.length = 0;
            for(index in items) 
            {
                if (items[index][0] == document.getElementById('select-market').value)
                {
                    select.options[select.options.length] = new Option(items[index][1], items[index][0] + '/' + items[index][1],false,false);
                }
            }
            
            $("#select-model").val(file[2]);

            $('#select-model').selectmenu('refresh', true);
            $('#select-market').selectmenu('refresh', true);

        }
    }

    function keyboardListener(e){
        if (e.keyCode == "27"){ // echap key
            $("#picking-img").trigger('click');
        }
        return true;
    }

    // Display a new session
    function changeSession()
    {
        // reset lists
        $('#select-model option').remove();
        $('#select-model').selectmenu('refresh', true);
        $('#select-market').find('option:selected').removeAttr('selected');
        $('#select-market').attr('selectedIndex', -1).selectmenu('refresh', true);

        var session = document.getElementById('select-session').options[document.getElementById('select-session').selectedIndex].value;

        var w = document.body.offsetWidth;
        var h = document.body.offsetHeight;

        if (w==0 || h==0)
            return null;
			
        if (renderArea == null)
        {
            renderArea = new RemoteVizRenderArea("TheDiv", w, h);
            // Listen start and stop bandwidth calibration events to display or hide the loader.
            renderArea.addServiceListener(service);
            renderArea.addMessageListener(messageReceive);
            renderArea.addKeyDownListener(keyboardListener);
            renderArea.connectTo("ws://" + ip + ":" + port + "/" + session);
        }
        else
        {
            renderArea.disconnect();
            renderArea.connectTo("ws://" + ip + ":" + port + "/" + session);
        }
    }

    // triggered when service send message.
    function service(event)
    {
        var message = event[0];
        switch(message) {
            case "startNetworkCalibration":
                document.getElementById("loaderGroup").style.display = "inline";
                break;
            case "finishedNetworkCalibration":
                document.getElementById("loaderGroup").style.display = "none";
                break;
        }
    }

    // triggered when the browser window is resized or the screen orientation is changed.
    function resizeOrUpdateOrientation() 
    {
        var w = document.body.offsetWidth;
        var h =  document.body.offsetHeight;

        if (w==0 || h==0)
            return null;
      
        if (renderArea != null) 
        {
            renderArea.resizeRenderAreaContainer(w, h);
            renderArea.requestRenderAreaSize(w, h);
        }

    }

    // triggered when the user clicks on the picking mode button
    function changePickingMode()
    {
        if ($("#checkbox-picking").is(':checked')) 
        {
            renderArea.sendMessage("pick on");
            $("#picking-img").attr('src','resources/Images/hand.png');
        } 
        else 
        {
            renderArea.sendMessage("pick off");
            $("#picking-img").attr('src','resources/Images/pointer.png');
        }
    }

    // triggered when the user changes the element of the model list
    function changeModel()
    {
        var file = document.getElementById("select-model").value;
        if (file != "")
        {
            renderArea.sendMessage("open " + file);
        }
    }

    // triggered when the user changes the element of the market list
    function changeMarket()
    {
        var select = document.getElementById("select-model");
        select.options.length = 0;
        for(index in items) 
        {
            if (items[index][0] == document.getElementById('select-market').value)
            {
                select.options[select.options.length] = new Option(items[index][1], items[index][0] + '/' + items[index][1],false,false);
            }
        }
        select.selectedIndex = -1;
    }