package util;


import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class Example extends JPanel
{

  public abstract void start();

  public abstract void stop();

  // called by demo main in stand-alone mode only
  protected void demoMain(String title)
  {
    start();

    final JFrame mainWindow = new JFrame(title);
    WindowListener l = new WindowAdapter()
    {
      @Override
      public void windowClosing(WindowEvent e)
      {
        stop();
        mainWindow.dispose();
        System.exit(0);
      }
    };
    mainWindow.addWindowListener(l);
    mainWindow.getContentPane().add(this);

    mainWindow.pack();
    mainWindow.setVisible(true);
  }
}
