package volumeviz.advanced.volRend;

import java.awt.Dimension;
import java.io.File;

import javax.swing.JCheckBox;
import javax.swing.SpringLayout;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class ColormapPanel extends VolRendPanel {

  protected String[] m_comboBoxItems = {
      "Seismic",
      "Standard",
      "Glow",
      "BlueRed",
      "Physics",
      "Temperature",
      "Grey",
      "BlueWhiteRed",
      "User Defined ColorMap"
  };
  private String m_defaultFilename = "BlueWhiteRed.txt";
  private int m_initItem;

  protected ChooserPanel m_colormapChooser;
  protected SliderPanel m_colormapMin;
  protected SliderPanel m_colormapMax;
  protected SliderPanel m_opaqueMin;
  protected SliderPanel m_opaqueMax;
  protected JCheckBox m_invert;

  public ColormapPanel(String title, int init_item) {
    super(title);

    m_initItem = init_item;

    try {
      jbInit();
    }
    catch (Exception e) {
     e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_colormapChooser = new ChooserPanel(m_comboBoxItems, new File(VolRend.m_filePrefix+ m_defaultFilename));
    m_colormapChooser.setSelectedItem(m_initItem);

    Dimension label_dim = new Dimension(90, 31);
    m_colormapMin = new SliderPanel(0, 255, 0);
    m_colormapMin.addInfoText("Colormap Min");
    m_colormapMin.setInfoTextSize(label_dim);

    m_colormapMax = new SliderPanel(0, 255, 255);
    m_colormapMax.addInfoText("Colormap Max");
    m_colormapMax.setInfoTextSize(label_dim);

    m_opaqueMin = new SliderPanel(0, 255, 0);
    m_opaqueMin.addInfoText("Opaque Min");
    m_opaqueMin.setInfoTextSize(label_dim);

    m_opaqueMax = new SliderPanel(0, 255, 255);
    m_opaqueMax.addInfoText("Opaque Max");
    m_opaqueMax.setInfoTextSize(label_dim);


    m_invert = new JCheckBox("Transparent outside min max");

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(m_colormapChooser);
    add(m_colormapMin);
    add(m_colormapMax);
    add(m_opaqueMin);
    add(m_opaqueMax);
    add(m_invert);

    sp_layout.putConstraint(SpringLayout.WEST, m_colormapChooser, 5,
                            SpringLayout.WEST, this);
    sp_layout.putConstraint(SpringLayout.NORTH, m_colormapChooser, 10,
                            SpringLayout.NORTH, this);
    sp_layout.putConstraint(SpringLayout.NORTH, m_colormapMin, 30,
                            SpringLayout.SOUTH, m_colormapChooser);
    sp_layout.putConstraint(SpringLayout.NORTH, m_colormapMax, 5,
                            SpringLayout.SOUTH, m_colormapMin);
    sp_layout.putConstraint(SpringLayout.NORTH, m_opaqueMin, 5,
                            SpringLayout.SOUTH, m_colormapMax);
    sp_layout.putConstraint(SpringLayout.NORTH, m_opaqueMax, 5,
                            SpringLayout.SOUTH, m_opaqueMin);
    sp_layout.putConstraint(SpringLayout.NORTH, m_invert, 30,
                            SpringLayout.SOUTH, m_opaqueMax);
  }

  public void reset() {
    m_colormapMin.setSliderValue(VolRend.MIN_COLORMAP);
    m_colormapMax.setSliderValue(VolRend.MAX_COLORMAP);
    m_opaqueMin.setSliderValue(VolRend.MIN_COLORMAP);
    m_opaqueMax.setSliderValue(VolRend.MAX_COLORMAP);
  }
}
