package volumeviz.advanced.volRend;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.*;
import javax.swing.plaf.metal.*;
import javax.swing.event.*;

public class DecorationPanel extends VolRendPanel {
  private String[] m_themesItems = {
      "Default", "White-Red", "White-Green", "White-Blue"
  };
  private VolRend m_volRend;
  private JFrame m_parentFrame;
  private UIManager.LookAndFeelInfo[] m_installedLAF;
  private JComboBox<String> m_themes;
  private BackgroundColorDialog m_bkgColorChooser;

  public DecorationPanel(VolRend volrend, JFrame parent) {
    super("DECORATION");
    m_volRend = volrend;
    m_parentFrame = parent;
    m_bkgColorChooser = null;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    // Background button
    JButton background_button = new JButton("Change Background");
    background_button.setPreferredSize(new Dimension(150, 30));
    Border button_border =
        BorderFactory.createBevelBorder(BevelBorder.RAISED,
                                        Color.white,Color.white,
                                        new Color(103, 101, 98),
                                        new Color(148, 145, 140));
    background_button.setBorder(button_border);
    background_button.addMouseListener(new BackgroundButtonListener());

    // CheckBox
    JCheckBox colormap =
        new JCheckBox("ColorMap Legend", m_volRend.m_infoSep.m_showColormap);
    colormap.addItemListener(new ColorMapItemListener());
    JCheckBox histo =
        new JCheckBox("Histogram Legend", m_volRend.m_infoSep.m_showHistogram);
    histo.addItemListener(new HistoItemListener());
    JCheckBox text =
        new JCheckBox("Annotation Text", m_volRend.m_infoSep.m_showText);
    text.addItemListener(new TextItemListener());

    JCheckBox bbox =
        new JCheckBox("BBox", m_volRend.m_volBBoxSwitch.m_showBBox);
    bbox.addItemListener(new BBoxItemListener());
    JCheckBox axes =
        new JCheckBox("Axes", m_volRend.m_volAxesSwitch.m_showAxes);
    axes.addItemListener(new AxesItemListener());

    // LAF and themes
    JLabel laf_label = new JLabel("Look And Feel");
    JComboBox<String> look_and_feel = new JComboBox<>();
    m_installedLAF = UIManager.getInstalledLookAndFeels();
    for (int i = 0; i < m_installedLAF.length; i++)
      look_and_feel.addItem(m_installedLAF[i].getName());

    look_and_feel.addActionListener(new LAFListener());

    JLabel themes_label = new JLabel("Themes");
    m_themes = new JComboBox<>(m_themesItems);
    m_themes.addActionListener(new ThemesListener());

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(colormap);
    add(histo);
    add(text);
    add(bbox);
    add(axes);
    add(background_button);
    add(laf_label);
    add(look_and_feel);
    add(themes_label);
    add(m_themes);

    sp_layout.putConstraint(SpringLayout.NORTH, colormap, 5,
                            SpringLayout.NORTH, this);
    sp_layout.putConstraint(SpringLayout.NORTH, histo, 10,
                            SpringLayout.SOUTH, colormap);
    sp_layout.putConstraint(SpringLayout.NORTH, text, 10,
                            SpringLayout.SOUTH, histo);
    sp_layout.putConstraint(SpringLayout.NORTH, bbox, 10,
                            SpringLayout.SOUTH, text);
    sp_layout.putConstraint(SpringLayout.NORTH, axes, 10,
                            SpringLayout.SOUTH, bbox);
    sp_layout.putConstraint(SpringLayout.NORTH, background_button, 20,
                            SpringLayout.SOUTH, axes);
    sp_layout.putConstraint(SpringLayout.WEST, background_button, 5,
                            SpringLayout.WEST, this);
    sp_layout.putConstraint(SpringLayout.NORTH, laf_label, 23,
                            SpringLayout.SOUTH, background_button);
    sp_layout.putConstraint(SpringLayout.WEST, laf_label, 5,
                            SpringLayout.WEST, this);
    sp_layout.putConstraint(SpringLayout.NORTH, look_and_feel, 20,
                            SpringLayout.SOUTH, background_button);
    sp_layout.putConstraint(SpringLayout.WEST, look_and_feel, 15,
                            SpringLayout.EAST, laf_label);
    sp_layout.putConstraint(SpringLayout.NORTH, themes_label, 23,
                            SpringLayout.SOUTH, background_button);
    sp_layout.putConstraint(SpringLayout.WEST, themes_label, 30,
                            SpringLayout.EAST, look_and_feel);
    sp_layout.putConstraint(SpringLayout.NORTH, m_themes, 20,
                            SpringLayout.SOUTH, background_button);
    sp_layout.putConstraint(SpringLayout.WEST, m_themes, 15,
                            SpringLayout.EAST, themes_label);
  }

  class ColorMapItemListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_volRend.m_infoSep.m_volColormapSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
      else
        m_volRend.m_infoSep.m_volColormapSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }
  }

  class HistoItemListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        m_volRend.m_infoSep.m_volHistoSwitch.whichChild.setValue(SoSwitch.
            SO_SWITCH_ALL);
        m_volRend.m_infoSep.m_showHistogram = true;
      } else {
        m_volRend.m_infoSep.m_volHistoSwitch.whichChild.setValue(SoSwitch.
            SO_SWITCH_NONE);
        m_volRend.m_infoSep.m_showHistogram = false;
      }
    }
  }

  class TextItemListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_volRend.m_infoSep.m_volTextSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
      else
        m_volRend.m_infoSep.m_volTextSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }
  }

  class BBoxItemListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        m_volRend.m_volBBoxSwitch.update();
        m_volRend.m_volBBoxSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
      }
      else
        m_volRend.m_volBBoxSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }
  }

  class AxesItemListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        m_volRend.m_volAxesSwitch.update();
        m_volRend.m_volAxesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
      }
      else
        m_volRend.m_volAxesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }
  }

  class BackgroundButtonListener extends MouseAdapter {

    public void mousePressed(MouseEvent e) {
      if (m_bkgColorChooser == null)
        m_bkgColorChooser = new BackgroundColorDialog();

      m_bkgColorChooser.m_colorChooserDialog.setVisible(true);

      /*
      Color selected_color = JColorChooser.showDialog
          (null, "Background Color Chooser", m_background.getBackground());
      if (selected_color != null) {
        float[] color_values = new float[3];
        SbColor new_color = new SbColor(selected_color.getColorComponents(color_values));
        m_area.getSceneManager().setBackgroundColor(new_color);
        m_background.setBackground(selected_color);
      }*/
    }
  }

  class LAFListener implements ActionListener {
    public void actionPerformed(ActionEvent evt) {
      int selected_index = ((JComboBox<?>)evt.getSource()).getSelectedIndex();
      String laf = m_installedLAF[selected_index].getClassName();

      try {
        UIManager.setLookAndFeel(laf);
        SwingUtilities.updateComponentTreeUI(m_parentFrame);
      }
      catch (Exception e) {
        System.err.println("Couldn't load " +
                           m_installedLAF[selected_index].getName() +
                           " look and feel " + e);
      }
      if (laf == MetalLookAndFeel.class.getName())
        m_themes.setEnabled(true);
      else
        m_themes.setEnabled(false);
    }
  }

  class ThemesListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = ( (JComboBox<?>) e.getSource()).getSelectedIndex();
      try {
        switch (selected_index) {
          case 0:
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
            break;
          case 1:
            MetalLookAndFeel.setCurrentTheme(new WhiteRedTheme());
            UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
            break;
          case 2:
            MetalLookAndFeel.setCurrentTheme(new WhiteGreenTheme());
            UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
            break;
          case 3:
            MetalLookAndFeel.setCurrentTheme(new WhiteBlueTheme());
            UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
            break;
        }
        SwingUtilities.updateComponentTreeUI(m_parentFrame);
      }
      catch (Exception exc) {
        exc.printStackTrace();
      }
    }
  }

  // Background Color Chooser dialog
  class BackgroundColorDialog {
    private JColorChooser m_backgroundChooser;
    private PreviewPanel m_previewPanel;
    private Color m_initColor0;
    private Color m_initColor1;

    public JDialog m_colorChooserDialog;

    public BackgroundColorDialog() {
      m_initColor0 = m_volRend.m_background.color0.getValue().toAWTColor();
      m_initColor1 = m_volRend.m_background.color1.getValue().toAWTColor();

      m_backgroundChooser = new JColorChooser();
      m_previewPanel = new PreviewPanel();
      m_backgroundChooser.setPreviewPanel(new JPanel()); // remove default preview panel
      m_backgroundChooser.setColor(m_initColor0);

      m_colorChooserDialog = JColorChooser.createDialog(null,
          "Background color",
          true, m_backgroundChooser,
          m_previewPanel, m_previewPanel);

      // add preview panel
      m_colorChooserDialog.getContentPane().add(m_previewPanel,
                                                BorderLayout.NORTH);
      m_colorChooserDialog.setSize(new Dimension(440, 450));
    }

    class PreviewPanel
        extends JPanel
        implements ChangeListener, ActionListener {
      private JCheckBox m_previewBox;
      private JCheckBox m_color0Box;
      private JCheckBox m_color1Box;
      private JPanel m_color0Preview;
      private JPanel m_color1Preview;

      public PreviewPanel() {
        m_previewBox = new JCheckBox("Preview");
        m_previewBox.addItemListener(new PreviewListener());

        // color 0 panel
        m_color0Box = new JCheckBox("Color 0");
        m_color0Box.setSelected(true);
        m_color0Preview = new JPanel();
        m_color0Preview.setBorder(BorderFactory.createLoweredBevelBorder());
        m_color0Preview.setPreferredSize(new Dimension(100, 10));
        m_color0Preview.setOpaque(true);
        m_color0Preview.setBackground(m_initColor0);

        JPanel color0_panel = new JPanel(new BorderLayout());
        color0_panel.add(m_color0Box, BorderLayout.WEST);
        color0_panel.add(m_color0Preview, BorderLayout.CENTER);

        // color 1 panel
        m_color1Box = new JCheckBox("Color 1");
        m_color1Preview = new JPanel();
        m_color1Preview.setBorder(BorderFactory.createLoweredBevelBorder());
        m_color1Preview.setPreferredSize(new Dimension(100, 10));
        m_color1Preview.setOpaque(true);
        m_color1Preview.setBackground(m_initColor1);

        JPanel color1_panel = new JPanel(new BorderLayout());
        color1_panel.add(m_color1Box, BorderLayout.WEST);
        color1_panel.add(m_color1Preview, BorderLayout.CENTER);

        ButtonGroup colors_group = new ButtonGroup();
        colors_group.add(m_color0Box);
        colors_group.add(m_color1Box);

        // preview panel
        SpringLayout sp_layout = new SpringLayout();
        setLayout(sp_layout);
        add(m_previewBox);
        add(color0_panel);
        add(color1_panel);
        sp_layout.putConstraint(SpringLayout.NORTH, m_previewBox, 5,
                                SpringLayout.NORTH, this);
        sp_layout.putConstraint(SpringLayout.NORTH, color0_panel, 5,
                                SpringLayout.SOUTH, m_previewBox);
        sp_layout.putConstraint(SpringLayout.NORTH, color1_panel, 5,
                                SpringLayout.SOUTH, color0_panel);
        sp_layout.putConstraint(SpringLayout.SOUTH, this, 15,
                                SpringLayout.SOUTH, color1_panel);

        m_backgroundChooser.getSelectionModel().addChangeListener(this);
      }

      // ColorChooser color changed
      public void stateChanged(ChangeEvent e) {
        Color color = m_backgroundChooser.getColor();
        if (m_color0Box.isSelected()) {
          // change panel color
          m_color0Preview.setBackground(color);
          if (m_previewBox.isSelected())
            // change background color
            m_volRend.m_background.color0.setValue(new SbColor(color));
        }
        else {
          // change panel color
          m_color1Preview.setBackground(color);
          if (m_previewBox.isSelected())
            // change background color
            m_volRend.m_background.color1.setValue(new SbColor(color));
        }
      }

      public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
          if (!m_previewBox.isSelected()) {
            // change background color
            m_previewBox.setSelected(true);
            m_previewBox.setSelected(false);
          }
          m_initColor0 = m_color0Preview.getBackground();
          m_initColor1 = m_color1Preview.getBackground();
        }
        if (e.getActionCommand() == "cancel") {
          // restore panels color
          m_color0Preview.setBackground(m_initColor0);
          m_color1Preview.setBackground(m_initColor1);
          if (m_previewBox.isSelected()) {
            // restore background color
            m_volRend.m_background.color0.setValue(new SbColor(m_initColor0));
            m_volRend.m_background.color1.setValue(new SbColor(m_initColor1));
          }
        }
      }

      class PreviewListener
          implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
          if (e.getStateChange() == ItemEvent.SELECTED) {
            Color color0 = m_color0Preview.getBackground();
            Color color1 = m_color1Preview.getBackground();
            m_volRend.m_background.color0.setValue(new SbColor(color0));
            m_volRend.m_background.color1.setValue(new SbColor(color1));
          }
        }
      }
    }
  } // end BackgroundColorDialog
}
