package volumeviz.advanced.volRend;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.SpringLayout;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class GeomControlPanel extends VolRendPanel {
  private VolRend m_volRend;
  private SliderPanel m_slices;

  public GeomControlPanel(VolRend vol_rend) {
    super("GEOMETRY CONTROL");
    m_volRend = vol_rend;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    JCheckBox aligned_slice = new JCheckBox("View Aligned Slice", false);
    aligned_slice.addItemListener(new AlignedSliceListener());

    m_slices = new SliderPanel(0, 0, 0);
    m_slices.addInfoText("Number of Slices");
    m_slices.setInfoTextSize(new Dimension(110, 31));
    m_slices.addSliderPanelListener(new SlicesListener());
    reset();

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(aligned_slice);
    add(m_slices);

    sp_layout.putConstraint(SpringLayout.NORTH, m_slices, 20,
                            SpringLayout.SOUTH, aligned_slice);
  }

  public void reset() {
    int nb_slices;
    int vol_width = m_volRend.m_volData.data.getSize().getX();
    if (vol_width > 200) {
      nb_slices = 200;
      m_volRend.m_volRenderSwitch.m_volRend.numSlices.setValue(nb_slices);
    }
    else if (vol_width > 100) {
      nb_slices = 70;
      m_volRend.m_volRenderSwitch.m_volRend.numSlices.setValue(nb_slices);
    }
    else
      nb_slices = 0;
    m_slices.setSliderMax(vol_width);
    m_slices.setSliderValue(nb_slices);
  }

  class AlignedSliceListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_volRend.m_volRenderSwitch.m_volRend.viewAlignedSlices.setValue(e.
          getStateChange() == ItemEvent.SELECTED);
    }
  }

  class SlicesListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volRend.m_volRenderSwitch.m_volRend.numSlices.setValue((int)value);
    }
  }
}
