package volumeviz.advanced.volRend;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example {
  private VolRend m_volRend;
  private  VolRendParamFrame m_vrf;
  private IViewerExaminer m_viewer;

  public static void main(String[] args) {
     Main example = new Main();
     example.demoMain("Volume Rendering");
   }

  @Override
  public void start()
  {
    m_viewer = ViewerComponentsFactory.createViewerExaminer();

    m_volRend = new VolRend();
    SoSeparator root = m_volRend.makeSceneGraph();
    m_volRend.setUpViewer(m_viewer, root);

    m_vrf = new VolRendParamFrame(m_volRend);
    m_vrf.setVisible(true);

    final Component component = m_viewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    m_vrf.dispose();
    m_volRend.stop();
    m_viewer.dispose();
  }

}
