package volumeviz.advanced.volRend;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import com.openinventor.inventor.nodes.*;
import javax.swing.tree.*;
import java.util.*;

public class MainOrthoSlicesPanel extends VolRendPanel {
  private VolRend m_volRend;
  private JTree m_tree;
  private Vector<OrthoSlicePanel> m_orthoSlicePanelTab;
  private DefaultMutableTreeNode m_orthoSlicesNode;
  private JComboBox<Integer> m_nbSlices;

  public MainOrthoSlicesPanel(VolRend vol_rend, JTree tree,
                              DefaultMutableTreeNode node) {
    super("ORTHO SLICE");

    m_volRend = vol_rend;
    m_tree = tree;
    m_orthoSlicesNode = node;

    OrthoSlicePanel ortho1 = new OrthoSlicePanel(1, m_volRend);
    ortho1.setSliceVisible(false);
    m_orthoSlicePanelTab = new Vector<>(1);
    m_orthoSlicePanelTab.add(ortho1);

    DefaultMutableTreeNode ortho_slice1_leaf = new DefaultMutableTreeNode
        (new ParamNode("Ortho Slice 1", ortho1));
    node.add(ortho_slice1_leaf);

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    JLabel nb_slices_label = new JLabel("Number of slices to create");
    nb_slices_label.setPreferredSize(new Dimension(180, 31));
    m_nbSlices = new JComboBox<>();
    m_nbSlices.setPreferredSize(new Dimension(45, 30));
    for (int i = 0; i <= 10; i++)
      m_nbSlices.addItem(new Integer(i));
    m_nbSlices.setSelectedIndex(1);
    m_nbSlices.addActionListener(new NbSlicesListener());
    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(nb_slices_label);
    add(m_nbSlices);

    sp_layout.putConstraint(SpringLayout.WEST, nb_slices_label, 5,
                            SpringLayout.WEST, this);
    sp_layout.putConstraint(SpringLayout.NORTH, nb_slices_label, 30,
                            SpringLayout.NORTH, this);
    sp_layout.putConstraint(SpringLayout.WEST, m_nbSlices, 5,
                            SpringLayout.EAST, nb_slices_label);
    sp_layout.putConstraint(SpringLayout.NORTH, m_nbSlices, 30,
                            SpringLayout.NORTH, this);
  }

  public void reset() {
    int selected_nb = m_nbSlices.getSelectedIndex();
    if (selected_nb != 0)
      m_volRend.m_sliceGroup.createOrthoSlices(selected_nb,
                                               SoSwitch.SO_SWITCH_ALL,
                                               m_volRend.m_root);

    for (int i = 0; i < selected_nb; i++)
      ((OrthoSlicePanel)m_orthoSlicePanelTab.elementAt(i)).
          resetPanel(m_volRend.m_sliceGroup.m_orthoTab[i].sliceNumber.getValue());
  }

  class NbSlicesListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_nb = ((JComboBox<?>)e.getSource()).getSelectedIndex();

      if (selected_nb == 0)
        m_volRend.m_sliceGroup.m_volRenderOrthSliceSwitch.whichChild.setValue(
            SoSwitch.SO_SWITCH_NONE);
      else {
        m_volRend.m_sliceGroup.createOrthoSlices(selected_nb,
                                                 SoSwitch.SO_SWITCH_ALL,
                                                 m_volRend.m_root);
        m_volRend.m_sliceGroup.m_volRenderOrthSliceSwitch.whichChild.setValue(
            SoSwitch.SO_SWITCH_ALL);
      }

      //DefaultMutableTreeNode node = (DefaultMutableTreeNode)m_tree.getSelectionPath().getLastPathComponent();
      DefaultTreeModel tree_model = (DefaultTreeModel)m_tree.getModel();
      int child_count = tree_model.getChildCount(m_orthoSlicesNode);

      // Remove nodes if needed
      for (int i = selected_nb; i < child_count; i++) {
        tree_model.removeNodeFromParent((DefaultMutableTreeNode)m_orthoSlicesNode.
                                        getLastChild());
        m_orthoSlicePanelTab.removeElementAt(selected_nb);
      }
      tree_model.reload();

      // Add nodes if needed
      for (int i = child_count; i < selected_nb; i++) {
        OrthoSlicePanel new_panel = new OrthoSlicePanel(i + 1, m_volRend);
        m_orthoSlicesNode.add(new DefaultMutableTreeNode(new ParamNode("Ortho Slice " +
            (i + 1), new_panel)));
        m_orthoSlicePanelTab.addElement(new_panel);
      }

      // Update panel
      for (int i = 0; i < selected_nb; i++)
        ((OrthoSlicePanel)m_orthoSlicePanelTab.elementAt(i)).
            resetPanel(m_volRend.m_sliceGroup.m_orthoTab[i].sliceNumber.getValue());

      m_tree.setSelectionPath(new TreePath(m_orthoSlicesNode.getPath()));
      for (int i = 0; i < m_tree.getRowCount(); i++)
        m_tree.expandRow(i);

      for (int i = 0; i < m_orthoSlicePanelTab.size(); i++)
          ((OrthoSlicePanel)m_orthoSlicePanelTab.elementAt(i)).setSliceVisible(true);
    }
  }
}
