package volumeviz.advanced.volRend;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class MatAndLightPanel extends VolRendPanel {
  private VolRend m_volRend;

  public MatAndLightPanel(VolRend vol_rend) {
    super("MATERIAL AND LIGHTING");
    m_volRend = vol_rend;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    // Lighting
    JCheckBox lighting = new JCheckBox("Lighting", false);
    lighting.addItemListener(new LightingListener());

    // Global alpha
    SliderPanel alpha = new SliderPanel(0.f, 1.f,
                                        Float.parseFloat(m_volRend.DEFAULT_ALPHA),
                                        3);
    alpha.addInfoText("Global alpha");
    alpha.setInfoTextSize(new Dimension(110, 31));
    alpha.addSliderPanelListener(new AlphaListener());

    // Editors buttons
    Border button_border =
        BorderFactory.createBevelBorder(BevelBorder.RAISED,
                                        Color.white,Color.white,
                                        new Color(103, 101, 98),
                                        new Color(148, 145, 140));
    Dimension button_dim = new Dimension(180, 30);
    JButton material_editor = new JButton("Material Editor");
    material_editor.setBorder(button_border);
    material_editor.setPreferredSize(button_dim);
    material_editor.addMouseListener(new MaterialEditorListener());
    JButton light_editor = new JButton("Directional Light Editor");
    light_editor.setBorder(button_border);
    light_editor.setPreferredSize(button_dim);
    light_editor.addMouseListener(new LightEditorListener());

    SpringLayout sp_layout = new SpringLayout();
    JPanel center_panel = new JPanel(sp_layout);
    center_panel.add(alpha);
    center_panel.add(material_editor);
    center_panel.add(light_editor);
    sp_layout.putConstraint(SpringLayout.NORTH, alpha, 30,
                            SpringLayout.NORTH, center_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, material_editor, 35,
                            SpringLayout.SOUTH, alpha);
    sp_layout.putConstraint(SpringLayout.WEST, material_editor, 5,
                            SpringLayout.WEST, center_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, light_editor, 35,
                            SpringLayout.SOUTH, alpha);
    sp_layout.putConstraint(SpringLayout.WEST, light_editor, 54,
                            SpringLayout.EAST, material_editor);

    setLayout(new BorderLayout());
    add(lighting, BorderLayout.NORTH);
    add(center_panel, BorderLayout.CENTER);
  }

  class LightingListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_volRend.m_volRenderSwitch.m_volRend.lighting.setValue(e.getStateChange()
          == ItemEvent.SELECTED);
    }
  }

  class AlphaListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volRend.m_material.transparency.setValue(1.f - value);
    }
  }

  class MaterialEditorListener extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
      m_volRend.m_mtlEditor.setVisible(true);
    }
  }

  class LightEditorListener extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
      m_volRend.m_volRenderSwitch.m_headlightEd.setVisible(true);
    }
  }
}
