package volumeviz.advanced.volRend;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

import com.openinventor.ldm.nodes.*;
import com.openinventor.ldm.manips.*;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.actions.*;
import com.openinventor.inventor.*;
import com.openinventor.inventor.draggers.*;

public class ROIPanel extends VolRendPanel {

  private JCheckBox m_subVolManipBox;
  private JCheckBox m_roiManipBox;
  private JCheckBox m_bboxRoi;
  private JCheckBox m_bboxSubVol;
  private JButton m_resetSubVolButton;
  private JButton m_resetBoxButton;

  private VolRend m_volRend;
  private SoROI m_roi;
  private SoROIManip m_roiManip;
  private ROIBBoxSwitch m_roiManipBoxBBox;
  private ROIBBoxSwitch m_roiManipSubVolBBox;

  boolean m_roiManipActivated = false;
  boolean m_subVolManipActivated = false;

  public ROIPanel(VolRend vol_rend) {
    super("ROI");

    m_volRend = vol_rend;
    m_roi = m_volRend.m_volRenderSwitch.m_volROI;
    m_roiManip = m_volRend.m_volRenderSwitch.m_ROIManip;
    m_roiManipBoxBBox = m_volRend.m_volRenderSwitch.m_roiManipBoxBBoxSwitch;
    m_roiManipSubVolBBox = m_volRend.m_volRenderSwitch.m_roiManipSubVolBBoxSwitch;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    GridBagLayout gridBagLayout = new GridBagLayout();

    /********* SubVolume *********/
    // SubVolume Manip Panel
    m_subVolManipBox = new JCheckBox("show Manip");
    m_subVolManipBox.setSelected(false);
    m_subVolManipBox.addItemListener(new ManipBoxListener(false));
    m_resetSubVolButton = new JButton("Reset");
    m_resetSubVolButton.setEnabled(false);
    m_resetSubVolButton.addMouseListener(new ResetSubVolListener());

    JPanel subVolManip_panel = new JPanel();
    subVolManip_panel.setLayout(gridBagLayout);
    subVolManip_panel.add(m_resetSubVolButton,
                          new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0
                                                 , GridBagConstraints.WEST,
                                                 GridBagConstraints.NONE,
                                                 new Insets(3, 2, 2, 1), 20, 0));
    subVolManip_panel.add(m_subVolManipBox,
                          new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0
                                                 , GridBagConstraints.WEST,
                                                 GridBagConstraints.VERTICAL,
                                                 new Insets(4, 0, 3, -80), 30,
                                                 2));
    // SubVolume BBox
    m_bboxSubVol = new JCheckBox("show BBox");
    m_bboxSubVol.addItemListener(new BBoxListener(false));

    JPanel subVolume_panel = new JPanel(new GridLayout(2, 1));
    TitledBorder tb1 = new TitledBorder(BorderFactory.createEtchedBorder
                                        (Color.red, new Color(148, 145, 140)),
                                        "SubVolume");
    subVolume_panel.setBorder(tb1);
    subVolume_panel.add(subVolManip_panel);
    subVolume_panel.add(m_bboxSubVol);
    subVolume_panel.setPreferredSize(new Dimension(392, 100));

    /********* roi Box Panel *********/
    // roi Manip panel
    m_roiManipBox = new JCheckBox("show Manip");
    m_roiManipBox.setSelected(false);
    m_roiManipBox.addItemListener(new ManipBoxListener(true));
    m_resetBoxButton = new JButton("Reset");
    m_resetBoxButton.setEnabled(false);
    m_resetBoxButton.addMouseListener(new ResetROIListener());
    JPanel roiManip_panel = new JPanel(gridBagLayout);
    roiManip_panel.add(m_roiManipBox,
                       new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0
                                                , GridBagConstraints.WEST,
                                                GridBagConstraints.VERTICAL,
                                                new Insets(4, 0, 3, -80), 30, 2));

    roiManip_panel.add(m_resetBoxButton,
                       new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0
                                              , GridBagConstraints.WEST,
                                              GridBagConstraints.NONE,
                                              new Insets(3, 2, 2, 1), 20, 0));

    // roi BBox
    m_bboxRoi = new JCheckBox("show BBox");
    m_bboxRoi.addItemListener(new BBoxListener(true));
    // Relative Panel
    JCheckBox full_box = new JCheckBox("relative to full volume");
    full_box.setSelected(true);
    JCheckBox subVolume_box = new JCheckBox("relative to subvolume");
    subVolume_box.addItemListener(new RelativeBoxListener());
    ButtonGroup bg = new ButtonGroup();
    bg.add(full_box);
    bg.add(subVolume_box);
    JPanel relative_panel = new JPanel(new GridLayout(1, 2));
    relative_panel.add(full_box);
    relative_panel.add(subVolume_box);
    // Flags Panel
    JPanel flags_panel = new JPanel();
    flags_panel.setLayout(gridBagLayout);
    JLabel flags_txt = new JLabel("Flags");
    String[] flags_items = {
        "SUB_VOLUME",
        "EXCLUSION_BOX",
        "CROSS",
        "CROSS_INVERT",
        "FENCE"
    };
    JComboBox<String> flags_box = new JComboBox<>(flags_items);
    flags_box.setPreferredSize(new Dimension(172, 20));
    flags_box.addActionListener(new FlagsBoxListener(flags_box));
    flags_panel.add(flags_txt,
                    new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                                           GridBagConstraints.WEST,
                                           GridBagConstraints.NONE,
                                           new Insets(5, 5, 0, 4), 19, 0));
    flags_panel.add(flags_box,
                    new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0,
                                           GridBagConstraints.CENTER,
                                           GridBagConstraints.HORIZONTAL,
                                           new Insets(5, 0, 4, 183), 0, 0));

    GridLayout gl3 = new GridLayout(4, 1);
    gl3.setVgap(7);
    JPanel roiBox_panel = new JPanel(gl3);
    TitledBorder tb2 = new TitledBorder(BorderFactory.createEtchedBorder
                                        (Color.green, new Color(148, 145, 140)),
                                        "ROI Box");
    roiBox_panel.setBorder(tb2);
    roiBox_panel.add(roiManip_panel);
    roiBox_panel.add(m_bboxRoi);
    roiBox_panel.add(relative_panel);
    roiBox_panel.add(flags_panel);
    roiBox_panel.setPreferredSize(new Dimension(392, 180));

    // Tools Panel
    JCheckBox constrained_box = new JCheckBox("Constrained manip");
    constrained_box.setSelected(true);
    constrained_box.addItemListener(new ConstraintBoxListener());

    JCheckBox apply_geometry_box = new JCheckBox("Apply to geometry");
    apply_geometry_box.setSelected(true);
    apply_geometry_box.addItemListener(new ApplyGeometryBoxListener());

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(constrained_box);
    add(apply_geometry_box);
    add(subVolume_panel);
    add(roiBox_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, apply_geometry_box, 10,
                            SpringLayout.SOUTH, constrained_box);
    sp_layout.putConstraint(SpringLayout.NORTH, subVolume_panel, 20,
                            SpringLayout.SOUTH, apply_geometry_box);
    sp_layout.putConstraint(SpringLayout.NORTH, roiBox_panel, 5,
                            SpringLayout.SOUTH, subVolume_panel);
  }

  public void reset() {
    m_roiManipBox.setSelected(false);
    m_subVolManipBox.setSelected(false);
    m_bboxRoi.setSelected(false);
    m_bboxSubVol.setSelected(false);
  }

  class ManipBoxListener implements ItemListener {

    private boolean m_boxManip;

    public ManipBoxListener(boolean box_manip) {
      m_boxManip = box_manip;
    }

    public void itemStateChanged(ItemEvent e) {
      SoROI roi;
      if (!m_roiManipActivated && !m_subVolManipActivated)
        roi = m_roi;
      else
        roi = m_roiManip;

      SoSearchAction searchAction = new SoSearchAction();
      searchAction.setSearchingAll(true);
      searchAction.setNode(roi);
      searchAction.apply(m_volRend.m_root);
      SoPath path = searchAction.getPath();

      if (e.getStateChange() == ItemEvent.DESELECTED) {
        if (!m_roiManipBox.isSelected() && !m_subVolManipBox.isSelected()) {
          m_roiManip.replaceManip(path, m_roi);
        }
        if (m_boxManip)
          m_roiManipActivated = false;
        else
          m_subVolManipActivated = false;
      }
      else if (e.getStateChange() == ItemEvent.SELECTED) {
        m_volRend.m_volRenderSwitch.m_volROISwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        m_roiManip.replaceNode(path);
        ((SoTabBoxDragger)m_roiManip.getDragger()).adjustScaleTabSize();
        SoMaterial material = (SoMaterial)(m_roiManip.getDragger()
                                           .getPart("tabPlane1.scaleTabMaterial"));
        if (m_boxManip) {
          material.diffuseColor.setValue(0, 1, 0);
          material.emissiveColor.setValue(0, 1, 0);
          m_roiManip.boxOn.setValue(true);
          m_roiManipActivated = true;
          m_subVolManipBox.setSelected(false);
        } else {
          material.diffuseColor.setValue(1, 0, 0);
          material.emissiveColor.setValue(1, 0, 0);
          m_roiManip.boxOn.setValue(false);
          m_subVolManipActivated = true;
          m_roiManipBox.setSelected(false);
        }
      }
      m_resetSubVolButton.setEnabled(m_subVolManipActivated);
      m_resetBoxButton.setEnabled(m_roiManipActivated);
    }
  }

  class ResetSubVolListener extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
      if (m_subVolManipActivated)
        m_roiManip.subVolume.setValue(m_volRend.m_volRenderSwitch.m_subVolInitSize);
    }
  }

  class ResetROIListener extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
      if (m_roiManipActivated)
        m_roiManip.box.setValue(m_volRend.m_volRenderSwitch.m_boxInitSize);
    }
  }

  class BBoxListener implements ItemListener {
    private boolean m_roiBBox;

    public BBoxListener(boolean roi_bBox) {
      m_roiBBox = roi_bBox;
    }

    public void itemStateChanged(ItemEvent e) {
       if (e.getStateChange() == ItemEvent.SELECTED) {
         m_volRend.m_volRenderSwitch.m_volROISwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
         if (m_roiBBox) {
           m_roiManipBoxBBox.update();
           m_roiManipBoxBBox.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
         } else {
           m_roiManipSubVolBBox.update();
           m_roiManipSubVolBBox.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
         }
       }
       else if (e.getStateChange() == ItemEvent.DESELECTED) {
         if (m_roiBBox)
           m_roiManipBoxBBox.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
         else
           m_roiManipSubVolBBox.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
       }
    }
  }

  class RelativeBoxListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      SoROI roi;
      if (!m_roiManipActivated && !m_subVolManipActivated)
        roi = m_roi;
      else
        roi = m_roiManip;

      roi.relative.setValue(e.getStateChange() == ItemEvent.SELECTED);
      if (roi.relative.getValue()) {
        m_roiManipBoxBBox.update();
        float[] bounds = m_roiManipSubVolBBox.getBBoxBounds();
        m_roiManipBoxBBox.setTranslation(new SbVec3f(bounds[0], bounds[1], bounds[2]));
      }
      else
        m_roiManipBoxBBox.resetTranslation();
    }
  }

  class FlagsBoxListener implements ActionListener {
    JComboBox<String> m_flagsBox;

    public FlagsBoxListener(JComboBox<String> box) {
      m_flagsBox = box;
    }

    public void actionPerformed(ActionEvent e) {
      int selectedItem = m_flagsBox.getSelectedIndex();
      SoROI roi;
      if (!m_roiManipActivated && !m_subVolManipActivated)
        roi = m_roi;
      else
        roi = m_roiManip;

      SoROI.FlagsType flags[] = {
          SoROI.FlagsType.SUB_VOLUME,
          SoROI.FlagsType.EXCLUSION_BOX,
          SoROI.FlagsType.CROSS,
          SoROI.FlagsType.CROSS_INVERT,
          SoROI.FlagsType.FENCE
      };
      roi.flags.setValue(flags[selectedItem]);
    }
  }

  class ConstraintBoxListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_roiManip.constrained.setValue(e.getStateChange() == ItemEvent.SELECTED);
    }
  }

  class ApplyGeometryBoxListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_volRend.m_sliceGroup.insertChild(m_volRend.m_volRenderSwitch.
                                           m_volROISwitch, 0);
      else if (e.getStateChange() == ItemEvent.DESELECTED)
        m_volRend.m_sliceGroup.removeChild(0);
    }
  }
}
