package volumeviz.advanced.volRend;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.draggers.*;
import com.openinventor.inventor.*;
import com.openinventor.inventor.fields.*;
import com.openinventor.inventor.misc.callbacks.*;
import com.openinventor.inventor.actions.*;
import com.openinventor.volumeviz.draggers.SoOrthoSliceDragger;
import com.openinventor.volumeviz.nodes.*;

public class SliceGroup extends SoGroup {

  public static final float SCALE_FACTOR_INIT = 0.4f;
  SbVec3f m_draggerNormal;
  SbVec3f m_draggerSlicePos;
  float m_scaleFactor;
  int m_lastNumSlices;
  int m_currentSlice;

  private SoVolumeData m_volData;

  SoJackDragger m_draggerVolRender;
  SoSwitch m_draggerVolRenderSwitch;
  SoSwitch m_volRenderOrthSliceSwitch;
  SoSwitch m_volRenderObliSliceSwitch;
  SoObliqueSlice m_obliSlice;
  SoSwitch m_draggerObliSwitch;
  SoJackDragger m_draggerObliSlice;
  SoClipPlane m_obliClipPlane;
  SoSwitch m_volRenderVolGeomSwitch;
  VolumeGeometry m_volGeom;

  SoGroup[] m_groupTab;
  SoOrthoSlice[] m_orthoTab;
  SoSwitch[] m_switchOrthoTab;
  SoSwitch m_switchForOrthoDragger;

  public SliceGroup(SoVolumeData vol_data) {
    super();
    m_draggerNormal = new SbVec3f(0, 0, 1);
    m_draggerSlicePos = new SbVec3f();
    m_volData = vol_data;

    float[] vol_size_values = m_volData.extent.getValue().getSize().getValue();
    float avg_size = (vol_size_values[0] + vol_size_values[1] + vol_size_values[2]) / 3;
    m_scaleFactor = SCALE_FACTOR_INIT * avg_size;

    m_lastNumSlices = 0;
    m_currentSlice = 0;

    m_groupTab = null;
    m_orthoTab = null;
    m_switchOrthoTab = null;

    build();
  }

  private void build() {
    //build dragger for volume rendering slice
    m_draggerVolRender = new SoJackDragger();
    m_draggerVolRender.setName("JackDraggerForOrthoSlice");
    m_draggerVolRender.setPart("rotator.rotator", null);
    m_draggerVolRender.setPart("rotator.rotatorActive", null);
    m_draggerVolRender.setPart("translator.xzTranslator.translator", null);
    m_draggerVolRender.setPart("translator.yzTranslator.translator", null);
    m_draggerVolRender.setPart("translator.xyTranslator.translator", null);
    m_draggerVolRender.setPart("translator.yzTranslator.translatorActive", null);
    m_draggerVolRender.setPart("translator.xzTranslator.translatorActive", null);
    m_draggerVolRender.setPart("translator.xyTranslator.translatorActive", null);

    m_draggerVolRender.addMotionCallback(new MotionSliceCallback(), null);
    m_draggerVolRender.rotation.setValue(new SbRotation(new SbVec3f(0, 1, 0),
        m_draggerNormal));
    m_draggerVolRender.scaleFactor.setValue(m_scaleFactor, m_scaleFactor, m_scaleFactor);

    m_draggerVolRenderSwitch = new SoSwitch();
    m_draggerVolRenderSwitch.setName("SwitchForOrthoDragger");
    m_draggerVolRenderSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    m_volRenderOrthSliceSwitch = new SoSwitch();
    m_volRenderOrthSliceSwitch.setName("SwitchForOrtho");
    m_volRenderOrthSliceSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    // Oblique slice
    m_volRenderObliSliceSwitch = new SoSwitch();
    m_volRenderObliSliceSwitch.setName("SwitchForOblique");
    m_obliSlice = new SoObliqueSlice();
    m_obliSlice.interpolation.setValue(SoObliqueSlice.Interpolations.LINEAR);
    m_volRenderObliSliceSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    m_draggerObliSwitch = new SoSwitch();
    m_draggerObliSwitch.setName("SwitchForObliqueDragger");
    m_draggerObliSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    m_draggerObliSlice = new SoJackDragger();
    m_draggerObliSlice.setName("JackForOblique");

    m_draggerObliSlice.addMotionCallback(new MotionObliSliceCallback(), null);
    m_draggerObliSlice.rotation.setValue(new SbRotation(new SbVec3f(0,1,0), m_draggerNormal));
    m_draggerObliSlice.scaleFactor.setValue(m_scaleFactor, m_scaleFactor, m_scaleFactor);

    m_obliClipPlane = new SoClipPlane();
    m_obliClipPlane.setName("ObliqueClipPlane");
    m_obliClipPlane.on.setValue(false);
    m_obliClipPlane.plane.connectFrom((SoField)m_obliSlice.plane);

    SoMaterial sliceMaterial = new SoMaterial();
    sliceMaterial.diffuseColor.setValue(0.4f,0.4f,0.4f);
    sliceMaterial.emissiveColor.setValue(0.6f,0.6f,0.6f);

    // Volume geometry
    m_volRenderVolGeomSwitch = new SoSwitch();
    m_volRenderVolGeomSwitch.setName("SwitchForVolumeGeometry");
    m_volRenderVolGeomSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    m_volGeom = new VolumeGeometry();

    { // Assemble slice group
      m_draggerObliSwitch.addChild(m_draggerObliSlice);
      m_volRenderObliSliceSwitch.addChild(m_draggerObliSwitch);
      m_volRenderObliSliceSwitch.addChild(m_obliSlice) ;
      m_volRenderObliSliceSwitch.addChild(m_obliClipPlane);

      m_draggerVolRenderSwitch.addChild(m_draggerVolRender);
      m_volRenderOrthSliceSwitch.addChild(m_draggerVolRenderSwitch);

      m_volRenderVolGeomSwitch.addChild(m_volGeom.createVolumeGeometryGraph());

      addChild(sliceMaterial);
      addChild(m_volRenderObliSliceSwitch);
      addChild(m_volRenderOrthSliceSwitch);
      addChild(m_volRenderVolGeomSwitch);
    }
  }

  public void addOrthoDraggerSwitch(SoSeparator root) {
    m_switchForOrthoDragger = new SoSwitch();
    m_switchForOrthoDragger.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    String prop = System.getProperty("VOLREND_numOrthoSlice", "1");
    m_volRenderOrthSliceSwitch.addChild(m_switchForOrthoDragger);
    int numSlices = Integer.valueOf(prop).intValue();
    createOrthoSlices(numSlices, SoSwitch.SO_SWITCH_ALL, root);
    if (numSlices > 1)
      m_orthoTab[1].axis.setValue(SoOrthoSlice.AxisType.Y);
    if (numSlices > 2)
      m_orthoTab[2].axis.setValue(SoOrthoSlice.AxisType.X);
  }

  //This function creates multiple orthoslices
  public void createOrthoSlices(int num, int orthoVis, SoSeparator root) {
    if (m_orthoTab != null) {
      m_switchForOrthoDragger.removeAllChildren();

      for (int i = 0; i < m_lastNumSlices; i++) {
        m_groupTab[i].removeChild(m_orthoTab[i]);
        m_switchOrthoTab[i].removeChild(m_groupTab[i]);
        m_volRenderOrthSliceSwitch.removeChild(m_switchOrthoTab[i]);
      }

      m_groupTab = null;
      m_switchOrthoTab = null;
      m_orthoTab = null;
    }

    m_orthoTab = new SoOrthoSlice[num];
    m_groupTab = new SoGroup[num];
    m_switchOrthoTab = new SoSwitch[num];
    int space = 0;
    for (int i = 0; i < num; i++) {
      //separator
      m_groupTab[i] = new SoGroup();
      //slice
      m_orthoTab[i] = new SoOrthoSlice();
      m_orthoTab[i].setName("AOrthoSlice");
      m_orthoTab[i].axis.setValue(SoOrthoSlice.AxisType.Z); //Z by default
      m_orthoTab[i].interpolation.setValue(SoOrthoSlice.Interpolations.LINEAR);
      m_orthoTab[i].sliceNumber.setValue(space);

      //invisible dragger
      SoOrthoSliceDragger orthoSliceDragger = new SoOrthoSliceDragger();

      //add in sep
      m_groupTab[i].addChild(m_orthoTab[i]);
      m_switchForOrthoDragger.addChild(orthoSliceDragger);

      //switch for slice
      m_switchOrthoTab[i] = new SoSwitch();
      m_switchOrthoTab[i].addChild(m_groupTab[i]);
      m_switchOrthoTab[i].whichChild.setValue(orthoVis);// all visible

      //add switch for slice in
      m_volRenderOrthSliceSwitch.addChild(m_switchOrthoTab[i]);

      //init dragger
      SoSearchAction searchAction = new SoSearchAction();
      searchAction.setSearchingAll(true);
      searchAction.setNode(m_orthoTab[i]);
      searchAction.apply(root);
      SoPath path = searchAction.getPath();
      orthoSliceDragger.orthoSlicePath.setValue(path);
      orthoSliceDragger.volumeExtent.setValue(m_volData.extent.getValue());
      orthoSliceDragger.volumeDimension.setValue(m_volData.data.getSize());

      space += (int)m_volData.data.getSize().getZ()/num;
    }

    m_lastNumSlices = num;
    m_currentSlice = 0;

    //reset dragger pos
    int sliceNumber = m_orthoTab[0].sliceNumber.getValue();
    resetDraggerPos(sliceNumber);
  }

  public void resetDraggerPos(int sliceNumber) {
    float xFrac, yFrac, zFrac;
    xFrac = yFrac = zFrac = 0.5f;
    SbVec3f[] vol_data_bounds = m_volData.extent.getValue().getMinMax();
    SbVec3i32 vol_data_dim = m_volData.data.getSize();

    switch (m_orthoTab[m_currentSlice].axis.getValue(SoOrthoSlice.AxisType.class)) {
      case X:
        m_draggerNormal.setValue(1, 0, 0);
        xFrac = (float) sliceNumber / (float) (vol_data_dim.getX() - 1);
        break;
      case Y:
        m_draggerNormal.setValue(0, 1, 0);
        yFrac = (float) sliceNumber / (float) (vol_data_dim.getY() - 1);
        break;
      case Z:
        m_draggerNormal.setValue(0, 0, 1);
        zFrac = (float) sliceNumber / (float) (vol_data_dim.getZ() - 1);
        break;
    }

    float x = vol_data_bounds[0].getX() +
        xFrac * (vol_data_bounds[1].getX() - vol_data_bounds[0].getX());
    float y = vol_data_bounds[0].getY() +
        yFrac * (vol_data_bounds[1].getY() - vol_data_bounds[0].getY());
    float z = vol_data_bounds[0].getZ() +
        zFrac * (vol_data_bounds[1].getZ() - vol_data_bounds[0].getZ());
    SbVec3f dragger_pos = new SbVec3f(x, y, z);
    setDraggerSlicePos(dragger_pos);

    m_draggerVolRender.enableValueChangedCallbacks(false);
    m_draggerVolRender.translation.setValue(dragger_pos);
    m_draggerVolRender.enableValueChangedCallbacks(true);
  }

  public void setDraggerSlicePos(SbVec3f pos) {
    // set the dragger position
    m_draggerSlicePos = pos;
    m_draggerVolRender.enableValueChangedCallbacks(false);
    m_draggerVolRender.translation.setValue(new SbVec3f(0, 0, 0));
    m_draggerVolRender.rotation.setValue(new SbRotation
                                         (new SbVec3f(0, 1, 0), m_draggerNormal));
    m_draggerVolRender.scaleFactor.setValue(m_scaleFactor, m_scaleFactor,
                                            m_scaleFactor);
    m_draggerVolRender.enableValueChangedCallbacks(true);
  }

  class MotionObliSliceCallback extends SoDraggerCB {
    public void invoke(SoDragger d) {
      SoJackDragger dragger = (SoJackDragger)d;
      SbVec3f planeNormal = new SbVec3f(0, 0, 1);
      SbVec3f draggerPos = dragger.translation.getValue();

      // rotate the plane's normal by the dragger rotation
      SbRotation rotation = dragger.rotation.getValue();
      planeNormal = rotation.multVec(new SbVec3f(0, 1, 0));

      // translate cross section and cross contour
      m_obliSlice.plane.setValue(new SbPlane(planeNormal, draggerPos));
    }
  }

  class MotionSliceCallback extends SoDraggerCB {
    public void invoke(SoDragger dragger) {
      m_draggerSlicePos.setValue(((SoJackDragger)dragger).translation.getValue());
      SbVec3f[] vol_data_bounds = m_volData.extent.getValue().getMinMax();
      float[] maxBounds = vol_data_bounds[1].getValue();
      SbVec3i32 vol_data_dim = m_volData.data.getSize();
      float[] values = m_draggerSlicePos.getValue();
      int sliceNumber = 0;
      
      switch(m_orthoTab[m_currentSlice].axis.getValue(SoOrthoSlice.AxisType.class)) {
        case X:
          sliceNumber = (int)(vol_data_dim.getX()/2.0f
                              + ((int)vol_data_dim.getX()/2
                                 / maxBounds[0]*values[0]));
          break;
        case Y:
          sliceNumber = (int)(vol_data_dim.getY()/2.0f
                              + ((int)vol_data_dim.getY()/2
                                 / maxBounds[1]*values[1]));
          break;
        case Z:
          sliceNumber = (int)(vol_data_dim.getZ()/2.0f
                              + ((int)vol_data_dim.getZ()/2
                                 / maxBounds[2]*values[2]));
          break;
      }
      m_orthoTab[m_currentSlice].sliceNumber.setValue(sliceNumber);
    }
  }
}
