package volumeviz.advanced.volRend; 

import java.awt.Dimension;

import javax.swing.SpringLayout;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.volumeviz.nodes.SoVolumeData;

public class SlicesTextControlPanel extends VolRendPanel {
  private SliderPanel m_slicesNumTextures;
  private SliderPanel m_sliceTextureLoadRate;
  private SoVolumeData m_volData;

  public SlicesTextControlPanel(SoVolumeData vol_data) {
    super("CONTROL PARAMETERS FOR SLICES TEXTURING");
    m_volData = vol_data;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    Dimension label_dim = new Dimension(170, 31);

    m_slicesNumTextures = new SliderPanel(1, 1024, 256);
    m_slicesNumTextures.addInfoText("# Textures for slices");
    m_slicesNumTextures.setInfoTextSize(label_dim);
    m_slicesNumTextures.addSliderPanelListener(new SlicesNumTexturesListener());

    m_sliceTextureLoadRate = new SliderPanel(1, 256, 64);
    m_sliceTextureLoadRate.addInfoText("Texture Load Rate for slices");
    m_sliceTextureLoadRate.setInfoTextSize(label_dim);
    m_sliceTextureLoadRate.addSliderPanelListener(new SliceTextureLoadRateListener());

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(m_slicesNumTextures);
    add(m_sliceTextureLoadRate);

    sp_layout.putConstraint(SpringLayout.NORTH, m_slicesNumTextures, 5,
                            SpringLayout.NORTH, this);
    sp_layout.putConstraint(SpringLayout.NORTH, m_sliceTextureLoadRate, 10,
                            SpringLayout.SOUTH, m_slicesNumTextures);
  }

  class SlicesNumTexturesListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volData.ldmResourceParameters.getValue().max2DTextures.setValue((int)value);
      m_sliceTextureLoadRate.setSliderValue(m_volData.ldmResourceParameters.getValue().tex2LoadRate.getValue());
    }
  }

  class SliceTextureLoadRateListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volData.ldmResourceParameters.getValue().tex2LoadRate.setValue( (int) value);
      m_slicesNumTextures.setSliderValue(m_volData.ldmResourceParameters.getValue().max2DTextures.getValue());
    }
  }
}
