package volumeviz.advanced.volRend;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.volumeviz.nodes.*;

public class TexturePanel extends VolRendPanel {

  private String[] m_renderStyleItems = {
      "Volume Rendering",
      "Pre-Integrated Volume Rendering",
      "Volume Skin"
  };
  private String[]  m_compositionItems = {
      "Alpha",
      "Sum",
      "Max"
  };
  private VolRend m_volRend;

  public TexturePanel(VolRend vol_rend) {
    super("TEXTURE");
    m_volRend = vol_rend;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    // Box panel
    JCheckBox compressed = new JCheckBox("Compressed", true);
    compressed.addItemListener(new CompressedListener());
    JCheckBox paletted = new JCheckBox("Paletted", true);
    paletted.addItemListener(new PalettedListener());
    JCheckBox shared = new JCheckBox("Shared", true);
    shared.addItemListener(new SharedListener());
    JCheckBox lowResMode = new JCheckBox("LowResMode", false);
    lowResMode.addItemListener(new LowResModeListener());

    GridLayout grid_layout = new GridLayout(4, 1);
    grid_layout.setVgap(10);
    JPanel checkBox_panel = new JPanel(grid_layout);
    checkBox_panel.add(compressed);
    checkBox_panel.add(paletted);
    checkBox_panel.add(shared);
    checkBox_panel.add(lowResMode);

    Dimension label_dim = new Dimension(100, 20);
    Dimension box_dim = new Dimension(150, 20);

    // Render style
    JLabel style_label = new JLabel("Render Style");
    style_label.setPreferredSize(label_dim);
    JComboBox<String> style_box = new JComboBox<>(m_renderStyleItems);
    style_box.setPreferredSize(box_dim);
    style_box.addActionListener(new RenderStyleListener());
    JPanel style_panel = new JPanel();
    style_panel.add(style_label);
    style_panel.add(style_box);

    // Composition
    JLabel composition_label = new JLabel("Composition");
    composition_label.setPreferredSize(label_dim);
    JComboBox<String> composition_box = new JComboBox<>(m_compositionItems);
    composition_box.setPreferredSize(box_dim);
    composition_box.addActionListener(new CompositionListener());
    JPanel composition_panel = new JPanel();
    composition_panel.add(composition_label);
    composition_panel.add(composition_box);

    // Interpolation
    InterpolationPanel interpolation = new InterpolationPanel();
    interpolation.setPreferredSize(new Dimension(263, 60));
    interpolation.addLinearInterpolationListener(new InterpolationListener());

    SpringLayout sp_layout = new SpringLayout();
    JPanel center_panel = new JPanel(sp_layout);
    center_panel.add(style_panel);
    center_panel.add(composition_panel);
    center_panel.add(interpolation);
    sp_layout.putConstraint(SpringLayout.NORTH, style_panel, 20,
                            SpringLayout.NORTH, center_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, composition_panel, 15,
                            SpringLayout.SOUTH, style_panel);
    sp_layout.putConstraint(SpringLayout.NORTH, interpolation, 20,
                            SpringLayout.SOUTH, composition_panel);

    setLayout(new BorderLayout());
    add(checkBox_panel, BorderLayout.NORTH);
    add(center_panel, BorderLayout.CENTER);
  }

  class CompressedListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_volRend.m_volData.useCompressedTexture.setValue(e.getStateChange() ==
          ItemEvent.SELECTED);
    }
  }

  class PalettedListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_volRend.m_volData.usePalettedTexture.setValue(e.getStateChange() ==
          ItemEvent.SELECTED);
    }
  }

  class SharedListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_volRend.m_volData.useSharedPalettedTexture.setValue(e.getStateChange() ==
          ItemEvent.SELECTED);
    }
  }

  class LowResModeListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_volRend.m_volRenderSwitch.m_volRend.lowScreenResolutionScale.setValue(10);
      m_volRend.m_volRenderSwitch.m_volRend.lowResMode.setValue(e.getStateChange() ==
          ItemEvent.SELECTED ? SoVolumeRender.LowResModes.DECREASE_SCREEN_RESOLUTION : SoVolumeRender.LowResModes.DECREASE_NONE);
    }
  }

  class InterpolationListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        m_volRend.m_volRenderSwitch.m_volRend.interpolation.setValue(
            SoVolumeRender.Interpolations.LINEAR);
        m_volRend.m_volRenderSwitch.m_volSkin.interpolation.setValue(
            SoVolumeSkin.Interpolations.LINEAR);
      } else {
        m_volRend.m_volRenderSwitch.m_volRend.interpolation.setValue(
            SoVolumeRender.Interpolations.NEAREST);
        m_volRend.m_volRenderSwitch.m_volSkin.interpolation.setValue(
            SoVolumeSkin.Interpolations.NEAREST);
      }
    }
  }

  class RenderStyleListener implements ActionListener {
    private float transparency = m_volRend.m_material.transparency.getValueAt(0);

    public void actionPerformed(ActionEvent e) {
      int selected_item = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      switch (selected_item) {
        case 0: // Volume Render
          m_volRend.m_volRenderSwitch.m_volRendQualitySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
          m_volRend.m_volRenderSwitch.m_volSkinSwitch.whichChild.setValue(0);
          m_volRend.m_material.diffuseColor.setValue(1, 1, 1);
          m_volRend.m_material.emissiveColor.setValue(0, 0, 0);
          m_volRend.m_material.transparency.setValue(transparency);
          break;
        case 1: // Pre-Integrated Volume Render
          m_volRend.m_volRenderSwitch.m_volRendQualitySwitch.whichChild.setValue(0);
          m_volRend.m_volRenderSwitch.m_volRendQuality.preIntegrated.setValue(true);
          m_volRend.m_volRenderSwitch.m_volSkinSwitch.whichChild.setValue(0);
          m_volRend.m_material.diffuseColor.setValue(1, 1, 1);
          m_volRend.m_material.emissiveColor.setValue(0, 0, 0);
          m_volRend.m_material.transparency.setValue(transparency);
          break;
        case 2: // Volume Skin
          m_volRend.m_volRenderSwitch.m_volRendQualitySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
          m_volRend.m_volRenderSwitch.m_volSkinSwitch.whichChild.setValue(1);
          m_volRend.m_material.diffuseColor.setValue(0.5f, 0.5f, 0.5f);
          m_volRend.m_material.emissiveColor.setValue(0.5f, 0.5f, 0.5f);
          m_volRend.m_material.transparency.setValue(0);
          break;
      }
    }
  }

  class CompositionListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_item = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      switch (selected_item) {
        case 0:
          m_volRend.m_volRenderSwitch.m_volRend.composition.setValue(
              SoVolumeRender.Compositions.ALPHA_BLENDING);
          break;
        case 1:
          m_volRend.m_volRenderSwitch.m_volRend.composition.setValue(
              SoVolumeRender.Compositions.SUM_INTENSITY);
          break;
        case 2:
          m_volRend.m_volRenderSwitch.m_volRend.composition.setValue(
              SoVolumeRender.Compositions.MAX_INTENSITY);
          break;
      }
    }
  }
}
