package volumeviz.advanced.volRend;

import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.*;
import com.openinventor.volumeviz.nodes.*;

public class VolBBoxSwitch extends SoSwitch {

  private BBoxSeparator m_bboxRoot;
  private SoVolumeData m_volData;
  boolean m_showBBox;

  public VolBBoxSwitch(SoVolumeData vol_data) {
    super();
    m_volData = vol_data;
    m_bboxRoot = new BBoxSeparator(new SbColor(1, 0, 1));
    addChild(m_bboxRoot);

    String prop = System.getProperty("VOLREND_showBBox", "false");
    m_showBBox = Boolean.valueOf(prop).booleanValue();
    if (m_showBBox)
      whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
  }

  public void update() {
    // Get volume geometry (bounds in modeling coords)
    SbBox3f vol_size = m_volData.extent.getValue();
    SbVec3f[] vol_bounds = vol_size.getMinMax();

    m_bboxRoot.update(vol_bounds);
  }
}
