package volumeviz.advanced.volRend;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;

import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class VolGeomNodePanel extends VolRendPanel {
  private SliceGroup m_sliceGroup;

  public VolGeomNodePanel(SliceGroup slice_group) {
    super("VOLUME GEOMETRY NODE");

    m_sliceGroup = slice_group;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    JCheckBox visibility = new JCheckBox("Visibility", false);
    visibility.addItemListener(new VisibilityListener());

    JCheckBox clip_geometry = new JCheckBox("Clip geometry", false);
    clip_geometry.addItemListener(new ClippingListener());

    GridLayout grid_layout = new GridLayout(3, 1);
    grid_layout.setVgap(10);
    JPanel buttons_panel = new JPanel(grid_layout);
    buttons_panel.add(visibility);
    buttons_panel.add(clip_geometry);

    SliderPanel offset = new SliderPanel(-0.1f, 0.1f, 0.0f, 3);
    offset.addInfoText("Offset");
    offset.setInfoTextSize(new Dimension(50, 31));
    offset.addSliderPanelListener(new OffsetSliderListener());

    SpringLayout sp_layout = new SpringLayout();
    JPanel offset_panel = new JPanel(sp_layout);
    SpringLayout.Constraints constraint = new SpringLayout.Constraints();
    constraint.setConstraint(SpringLayout.NORTH, Spring.constant(30));
    offset_panel.add(offset, constraint);

    InterpolationPanel interpolation = new InterpolationPanel();
    interpolation.addLinearInterpolationListener(new InterpolationListener());

    JPanel center_panel = new JPanel(new BorderLayout());
    center_panel.add(interpolation, BorderLayout.NORTH);
    center_panel.add(offset_panel, BorderLayout.CENTER);

    setLayout(new BorderLayout());
    add(buttons_panel, BorderLayout.NORTH);
    add(center_panel, BorderLayout.CENTER);
  }

  class OffsetSliderListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_sliceGroup.m_volGeom.setVolumeGeometryOffset(value);
    }
  }

  class VisibilityListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
        m_sliceGroup.m_volRenderVolGeomSwitch.whichChild.setValue(SoSwitch.
            SO_SWITCH_ALL);
      else
        m_sliceGroup.m_volRenderVolGeomSwitch.whichChild.setValue(SoSwitch.
            SO_SWITCH_NONE);
    }
  }

  class ClippingListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_sliceGroup.m_volGeom.setVolumeGeometryClipping(e.getStateChange()
          == ItemEvent.SELECTED);
    }
  }

  class InterpolationListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      m_sliceGroup.m_volGeom.setVolumeGeometryInterpolation(e.getStateChange()
          == ItemEvent.SELECTED);
    }
  }
}
