package volumeviz.advanced.volRend;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoPackedColor;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor.CameraMode;

import util.ViewerComponentsFactory;

public class VolRendProfView {
  private IRenderAreaExaminer m_profileViewer;
  private SoSeparator m_profileRoot;
  private SoSeparator m_textRoot;
  private Frame m_frame;

  public VolRendProfView(Frame volRend_frame) {
    // Scene Graph.
    m_profileRoot = new SoSeparator();

    m_textRoot = new SoSeparator();
    m_profileRoot.addChild(m_textRoot);
    SoPackedColor txtColor = new SoPackedColor();
    txtColor.orderedRGBA.setValue(0xFFFF00FF);
    m_textRoot.addChild(txtColor);

    m_profileViewer = ViewerComponentsFactory.createRenderAreaExaminer();
    m_profileViewer.setCameraType(CameraMode.ORTHOGRAPHIC);
    m_profileViewer.setNavigationMode(NavigationMode.PLANE);
    m_profileViewer.setSceneGraph(m_profileRoot);

    m_profileViewer.viewAll(new SbViewportRegion(m_profileViewer.getComponent().getSize()));
    m_profileViewer.getRootSceneGraph().getCamera().viewportMapping.setValue(SoCamera.ViewportMappings.LEAVE_ALONE);

    WindowListener l = new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    };
    m_frame = new Frame("Pick Profile");
    m_frame.addWindowListener(l);
    m_frame.add(m_profileViewer.getComponent());
    m_frame.pack();
    m_frame.setSize(volRend_frame.getWidth(), (int)(volRend_frame.getHeight()/3.));
    m_frame.setLocation(volRend_frame.getLocation().x,
                        volRend_frame.getLocation().y + volRend_frame.getHeight());
  }

  public SoSeparator getProfileRoot() {
    return m_profileRoot;
  }

  public SoSeparator getTextProfileRoot() {
    return m_textRoot;
  }

  public void showProfile() {
    m_frame.setVisible(true);
  }

  public void hideProfile() {
    m_frame.setVisible(false);
  }

  public boolean isVisibleProfile() {
    return m_frame.isVisible();
  }

  public void profileViewAll() {
    m_profileViewer.viewAll(new SbViewportRegion(m_profileViewer.getComponent().getSize()));
  }
}
