package volumeviz.advanced.volRend;

import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.nodes.*;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.ldm.manips.SoROIManip;
import com.openinventor.ldm.nodes.SoROI;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;
import com.openinventor.volumeviz.nodes.SoVolumeSkin;

import util.editors.DirectionalLightEditor;

public class VolRenderSwitch extends SoSwitch {
  private SoVolumeData m_volData;
  boolean m_isFrontBufRendering;
  SbBox3i32 m_boxInitSize;
  SbBox3i32 m_subVolInitSize;

  SoSwitch m_volROISwitch;
  SoSwitch m_volROIDraggerSwitch;
  SoPickStyle m_volROIPickStyle;
  SoROIManip m_ROIManip;
  SoROI m_volROI;
  ROIBBoxSwitch m_roiManipBoxBBoxSwitch;
  ROIBBoxSwitch m_roiManipSubVolBBoxSwitch;
  SoPickStyle m_pick;
  SoSwitch m_volSkinSwitch;
  DirectionalLightEditor m_headlightEd;
  SoSwitch m_volRendQualitySwitch;
  SoVolumeRenderingQuality m_volRendQuality;
  SoVolumeRender m_volRend;
  SoVolumeSkin m_volSkin;

  SoFieldSensor m_roiManip_sensor;
  SoFieldSensor m_subVol_sensor;

  public VolRenderSwitch(SoVolumeData vol_data) {
    super();

    m_volData = vol_data;
    m_isFrontBufRendering = false;

    build();
  }

  private void build() {
    m_volRend = new SoVolumeRender();
    m_volRend.interpolation.setValue(SoVolumeRender.Interpolations.LINEAR);
    m_volRend.composition.setValue(SoVolumeRender.Compositions.ALPHA_BLENDING);
    m_volRend.numSlicesControl.setValue(SoVolumeRender.NumSlicesControls.AUTOMATIC);

    // Node specific rendering options
    String prop_value;
    prop_value = System.getProperty("VOLREND_lighting", "false");
    m_volRend.lighting.setValue(Boolean.valueOf(prop_value).booleanValue());

    prop_value = System.getProperty("VOLREND_viewAlignedSlices", "false");
    m_volRend.viewAlignedSlices.setValue(Boolean.valueOf(prop_value).booleanValue());

    prop_value = System.getProperty("VOLREND_numSlicesControl", "2"); // AUTOMATIC
    m_volRend.numSlicesControl.setValue(Integer.valueOf(prop_value).intValue());

    prop_value = System.getProperty("VOLREND_numSlices", "-1"); // not used by default
    int value = Integer.valueOf(prop_value).intValue();
    if (value > 0)
      m_volRend.numSlices.setValue(value);

    m_headlightEd = new DirectionalLightEditor();
    m_headlightEd.setTitle("Light Direction Editor");
    SoDirectionalLight direct_light = new SoDirectionalLight();
    direct_light.direction.setValue(m_volRend.lightDirection.getValue());
    SoPath little_path = new SoPath(direct_light);
    m_headlightEd.attach(little_path);
    m_volRend.lightDirection.connectFrom(direct_light.direction);

    m_volRendQuality = new SoVolumeRenderingQuality();
    
    m_volRendQualitySwitch = new SoSwitch();
    m_volRendQualitySwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    m_volRendQualitySwitch.addChild(m_volRendQuality);

    //////////////////////////////////////
    SoAntiSquish pAnti = new SoAntiSquish();
    pAnti.recalcAlways.setValue(true);

    SoScale vol_ROI_scale = new SoScale();
    vol_ROI_scale.setName("ScaleForROI");
    SbBox3f volBox = m_volData.extent.getValue();
    float[] size = volBox.getSize().getValue();
    float maxSize = size[0];
    if (maxSize < size[1])
      maxSize = size[1];
    if (maxSize < size[2])
      maxSize = size[2];
    vol_ROI_scale.scaleFactor.setValue(size[0]/maxSize, size[1]/maxSize, size[2]/maxSize);

    SoSeparator pTabGroup = new SoSeparator();
    pTabGroup.setName("GroupForROIAttributes");
    m_volROIPickStyle = new SoPickStyle();
    pTabGroup.addChild(vol_ROI_scale);
    pTabGroup.addChild(m_volROIPickStyle); // does not prevent picking the volume.     mmh
    //pTabGroup.addChild( pAnti );
    ///////////////////////////////////////

    m_volROIDraggerSwitch = new SoSwitch();
    m_volROIDraggerSwitch.setName("SwitchForROI");
    m_volROIDraggerSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);

    SbVec3i32 vol_data_dim = m_volData.data.getSize();
    m_volROI = new SoROI();
    m_volROI.setName("ROI");
    m_volROI.box.setValue(0, 0, 0,vol_data_dim.getX()-1,
                         vol_data_dim.getY()-1,
                         vol_data_dim.getZ()-1 );
    m_volROI.subVolume.setValue(0, 0, 0,vol_data_dim.getX()-1,
                               vol_data_dim.getY()-1,
                               vol_data_dim.getZ()-1 );

    m_volROISwitch = new SoSwitch();
    m_volROISwitch.setName("ROISwitch"); // debug

    m_ROIManip = new SoROIManip();
    m_boxInitSize = new SbBox3i32(new SbVec3i32(0, 0, 0),
                                vol_data_dim.minus(new SbVec3i32(1, 1, 1)));
    m_subVolInitSize = new SbBox3i32(new SbVec3i32(0, 0, 0),
                                   vol_data_dim.minus(new SbVec3i32(1, 1, 1)));
    m_ROIManip.box.setValue(m_boxInitSize);
    m_ROIManip.subVolume.setValue(m_subVolInitSize);
    m_ROIManip.constrained.setValue(true);
    m_ROIManip.setName("ROIManip");
    // ROI Manip BBox
    m_roiManipBoxBBoxSwitch =
        new ROIBBoxSwitch(m_volData, m_ROIManip.box, new SbColor(0, 1, 0));
    m_roiManipSubVolBBoxSwitch =
        new ROIBBoxSwitch(m_volData, m_ROIManip.subVolume, new SbColor(1, 0, 0));

    // Picking
    m_pick = new SoPickStyle();
    m_pick.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    // Setup to allow rendering volume in front buffer (mmh Dec-2000)
    SoFrontBufferGroup pFBGroup = new SoFrontBufferGroup();
    pFBGroup.setName("FBufGroup");
    if (m_volData.storageHint.getValue(SoVolumeData.StorageHints.class) != SoVolumeData.StorageHints.TEX2D) {
      m_isFrontBufRendering = false;
      pFBGroup.enable.setValue(false);     // Normal rendering for now...
    }
    else {
      m_isFrontBufRendering = true;
      pFBGroup.enable.setValue(true);
    }
    // This switch allows to choose volumeSkin or volumeRender for display
    m_volSkinSwitch = new SoSwitch();
    m_volSkinSwitch.whichChild.setValue(0);

    m_volSkin = new SoVolumeSkin();

    SoGroup pVolRendGrp = new SoGroup();
    pVolRendGrp.setName("VolRendGrp");

    setName("SwitchForVolumeRenderNodes");
    whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    {
      m_volROIDraggerSwitch.addChild(m_volROIPickStyle);
      m_volROISwitch.addChild(m_volROIDraggerSwitch);
      m_volROISwitch.addChild(m_volROI);
      m_volROISwitch.addChild(m_roiManipSubVolBBoxSwitch);
      m_volROISwitch.addChild(m_roiManipBoxBBoxSwitch);
      m_volSkinSwitch.addChild(m_volRend);
      m_volSkinSwitch.addChild(m_volSkin);
      pFBGroup.addChild(m_volSkinSwitch);
      // NOTE: Use the insertChild instead of addChild to have ROI affect
      // the slices (in addition to volume), else they are not affected.
      pVolRendGrp.addChild(m_volROISwitch);
      pVolRendGrp.addChild(m_pick);
      pVolRendGrp.addChild(m_volRendQualitySwitch);
      pVolRendGrp.addChild(pFBGroup);
      addChild(pVolRendGrp);
    }

    Runnable box_run = new Runnable() {
      public void run() {
        m_roiManipBoxBBoxSwitch.update();
      }
    };
    m_roiManip_sensor = new SoFieldSensor(box_run);
    m_roiManip_sensor.attach(m_ROIManip.box);

    Runnable subVol_run = new Runnable() {
      public void run() {
        m_roiManipSubVolBBoxSwitch.update();
        if (m_ROIManip.relative.getValue() || m_volROI.relative.getValue()) {
          m_roiManipBoxBBoxSwitch.update();
          float[] bounds = m_roiManipSubVolBBoxSwitch.getBBoxBounds();
          m_roiManipBoxBBoxSwitch.setTranslation(new SbVec3f(bounds[0], bounds[1], bounds[2]));
        }
      }
    };
    m_subVol_sensor = new SoFieldSensor(subVol_run);
    m_subVol_sensor.attach(m_ROIManip.subVolume);
  }
}
