package volumeviz.advanced.volRend; 
import java.awt.Dimension;

import javax.swing.SpringLayout;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.volumeviz.nodes.SoVolumeData;

public class VolTextControlPanel extends VolRendPanel {
  private SliderPanel m_numTexturesMb;
  private SliderPanel m_numTextures;
  private SliderPanel m_textureLoadRate;
  private SoVolumeData m_volData;

  public VolTextControlPanel(SoVolumeData vol_data) {
    super("CONTROL PARAMETERS FOR VOLUME TEXTURING");
    m_volData = vol_data;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    Dimension label_dim = new Dimension(105, 31);

    m_numTexturesMb = new SliderPanel(1, 128, 48);
    m_numTexturesMb.addInfoText("Amount in MB");
    m_numTexturesMb.setInfoTextSize(label_dim);
    m_numTexturesMb.addSliderPanelListener(new NumTexturesMbListener());

    m_numTextures = new SliderPanel(1, 512, 192);
    m_numTextures.addInfoText("# Textures");
    m_numTextures.setInfoTextSize(label_dim);
    m_numTextures.addSliderPanelListener(new NumTexturesListener());

    m_textureLoadRate = new SliderPanel(0, 64, 1);
    m_textureLoadRate.addInfoText("Texture Load Rate");
    m_textureLoadRate.setInfoTextSize(label_dim);
    m_textureLoadRate.addSliderPanelListener(new TextureLoadRateListener());

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    add(m_numTexturesMb);
    add(m_numTextures);
    add(m_textureLoadRate);

    sp_layout.putConstraint(SpringLayout.NORTH, m_numTexturesMb, 5,
                            SpringLayout.NORTH, this);
    sp_layout.putConstraint(SpringLayout.NORTH, m_numTextures, 10,
                            SpringLayout.SOUTH, m_numTexturesMb);
    sp_layout.putConstraint(SpringLayout.NORTH, m_textureLoadRate, 10,
                            SpringLayout.SOUTH, m_numTextures);
  }

  class NumTexturesMbListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volData.ldmResourceParameters.getValue().maxTexMemory.setValue((int)value);
      m_numTextures.setSliderValue(m_volData.ldmResourceParameters.getValue().maxTilesInMainMem.getValue());
      m_textureLoadRate.setSliderValue(m_volData.ldmResourceParameters.getValue().tex3LoadRate.getValue());
    }
  }

  class NumTexturesListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volData.ldmResourceParameters.getValue().maxTilesInMainMem.setValue((int)value);
      m_numTexturesMb.setSliderValue(m_volData.ldmResourceParameters.getValue().maxTexMemory.getValue());
      m_textureLoadRate.setSliderValue(m_volData.ldmResourceParameters.getValue().tex3LoadRate.getValue());
    }
  }

  class TextureLoadRateListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_volData.ldmResourceParameters.getValue().tex3LoadRate.setValue((int)value);
      m_numTextures.setSliderValue(m_volData.ldmResourceParameters.getValue().maxTilesInMainMem.getValue());
      m_numTexturesMb.setSliderValue(m_volData.ldmResourceParameters.getValue().maxTexMemory.getValue());
    }
  }
}
