package volumeviz.sample.customtags;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.openinventor.ldm.readers.SoVRLdmFileReader;
import com.openinventor.ldm.readers.SoVolumeReader;
import com.openinventor.ldm.xml.SbXmlTag;
import com.openinventor.volumeviz.nodes.SoVolumeData;

import util.Example;

/**
 * Example program.<br>
 * Purpose : Demonstrate retrieving custom tags from LDM file header<br>
 * Author : MHeck February 2005
 * <p>
 * Expected output is:<br>
 * <ul>
 * TileSize:<no text><br>
 * U:64<br>
 * V:64<br>
 * W:64<br>
 * MyCustomTags:<no text><br>
 * CustomTag1:Some custom info<br>
 * CustomTag2:More custom info
 *
 */
public class Main extends Example
{

  JTextArea m_txtArea = new JTextArea();

  @Override
  public void start()
  {
    SoVolumeData pVolData = new SoVolumeData();
    pVolData.fileName.setValue("$OIVJHOME/data/volumeviz/syn_64_custom.ldm");

    SoVolumeReader pReader = pVolData.getReader();
    if ( pReader == null )
      m_txtArea.append("Error: No reader!\n");
    else
    {
      SoVolumeReader.ReaderTypes rtype = pReader.getReaderType();
      if ( rtype != SoVolumeReader.ReaderTypes.LDM )
        m_txtArea.append("Error: Not an LDM reader!\n");
      else
      {
        SoVRLdmFileReader pLdmReader = (SoVRLdmFileReader) pReader;

        String tag1 = "TileSize";
        printTagSection(pLdmReader, tag1);

        String tag2 = "MyCustomTags";
        printTagSection(pLdmReader, tag2);
      }
    }

    m_txtArea.setEditable(false);
    JScrollPane jsp = new JScrollPane(m_txtArea);
    jsp.setPreferredSize(new Dimension(400, 300));

    setLayout(new BorderLayout());
    add(jsp);
  }

  @Override
  public void stop()
  {}

  private void printTagSection(SoVRLdmFileReader pLdmReader, String tag)
  {
    SbXmlTag tagSection = pLdmReader.getXmlTag(tag);

    if ( tagSection.exist() )
    {
      String text = tagSection.getText();
      if ( text == null )
        text = "<no text>";

      m_txtArea.append(tagSection.getName() + ":" + text + "\n");

      SbXmlTag t = tagSection.getFirstChildTag();
      while ( t.exist() )
      {
        text = t.getText();
        if ( text == null )
          text = "<no text>";

        m_txtArea.append(t.getName() + ":" + text + "\n");

        t = t.getNextSiblingTag();
      }
    }
    else
      m_txtArea.append("Error: Tag " + tag + " not found!\n");
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Custom tags");
  }

}
