package volumeviz.sample.dicomSimpleViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.ldm.nodes.SoDataRange;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.ldm.readers.SoVolumeReader.DataInfo;
import com.openinventor.medical.helpers.MedicalHelper;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.readers.SoVRDicomFileReader;
import com.openinventor.volumeviz.readers.dicom.SiDicomDataSet;
import com.openinventor.volumeviz.readers.dicom.SiDicomElement;
import com.openinventor.volumeviz.readers.dicom.SiDicomSequence;
import com.openinventor.volumeviz.readers.dicom.SiDicomValue;
import com.openinventor.volumeviz.readers.dicom.SoDicomTag;

import util.Example;
import util.ViewerComponentsFactory;

/**
 * This demo shows off reading DICOM tags with features introduced in OIV 9.8
 *
 */
public class Main extends Example
{
  private static final DecimalFormat decFormat = new DecimalFormat("###", new DecimalFormatSymbols(Locale.ENGLISH));

  DefaultListModel<String> m_sliceModel = new DefaultListModel<String>();
  JList<String> m_sliceView = new JList<String>(m_sliceModel);

  DefaultMutableTreeNode m_treeRoot = new DefaultMutableTreeNode("Tag Root");
  DefaultTreeModel m_infoModel = new DefaultTreeModel(m_treeRoot);
  JTree m_infoView = new JTree(m_infoModel);

  SoVRDicomFileReader m_reader;
  SoVolumeData m_volumeData;
  SoDataRange m_dataRange;
  SoOrthoSlice m_slice;

  IViewerExaminer m_viewer;

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("DICOM Viewer");
  }

  private void fillDataSetItem(SiDicomDataSet ds, DefaultMutableTreeNode parent)
  {
    for ( int i = 0; i < ds.getLength(); ++i )
    {
      SiDicomElement element = ds.getElement(i);
      SoDicomTag tag = element.getTag();
      SiDicomValue value = element.getValue();
      SiDicomSequence seq = element.getSequence();

      String tagInfoString = "(" + decFormat.format(tag.getGroup()) + ", " + decFormat.format(tag.getElement()) + ") ["
          + tag.getName() + "] => ";
      if ( value != null )
        tagInfoString += value.asString();

      DefaultMutableTreeNode item = new DefaultMutableTreeNode(tagInfoString);
      parent.add(item);

      if ( seq != null )
        fillSequenceItem(seq, item);
    }

  }

  private void fillSequenceItem(SiDicomSequence seq, DefaultMutableTreeNode parent)
  {
    for ( int i = 0; i < seq.getLength(); ++i )
    {
      SiDicomDataSet ds = seq.getItem(i);

      DefaultMutableTreeNode item = new DefaultMutableTreeNode("Item#" + (i + 1));
      fillDataSetItem(ds, item);

      parent.add(item);
    }
  }

  @Override
  public void start()
  {
    m_viewer = ViewerComponentsFactory.createViewerExaminer();

    m_reader = new SoVRDicomFileReader();

    m_sliceView.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    m_sliceView.addListSelectionListener(new ListSelectionListener()
    {
      @Override
      public void valueChanged(ListSelectionEvent arg0)
      {
        if ( m_sliceView.getSelectedIndex() >= 0 )
        {
          m_slice.sliceNumber.setValue(m_sliceView.getSelectedIndex());

          SiDicomDataSet dicomDataSet = m_reader.getDicomDataSet(m_sliceView.getSelectedIndex());

          m_treeRoot.removeAllChildren();

          for ( int i = 0; i < dicomDataSet.getLength(); ++i )
          {
            SiDicomElement element = dicomDataSet.getElement(i);
            SoDicomTag tag = element.getTag();
            SiDicomValue value = element.getValue();
            SiDicomSequence sequence = element.getSequence();

            String tagInfoString = "(" + decFormat.format(tag.getGroup()) + ", " + decFormat.format(tag.getElement())
                + ") [" + tag.getName() + "] => ";
            if ( value != null )
              tagInfoString += value.asString();

            DefaultMutableTreeNode tagInfo = new DefaultMutableTreeNode(tagInfoString);

            if ( sequence != null )
              fillSequenceItem(sequence, tagInfo);

            m_treeRoot.add(tagInfo);
          }
        }
      }
    });

    SoSeparator root = new SoSeparator();
    m_dataRange = new SoDataRange();

    m_volumeData = new SoVolumeData();

    SoTransferFunction pTransFunc = new SoTransferFunction();
    pTransFunc.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.INTENSITY);

    m_slice = new SoOrthoSlice();

    root.addChild(m_dataRange);
    root.addChild(m_volumeData);
    root.addChild(pTransFunc);
    root.addChild(m_slice);

    m_viewer.getRenderArea().setTransparencyType(SoGLRenderAction.TransparencyTypes.BLEND);
    m_viewer.setSceneGraph(root);

    loadPath("$OIVJHOME/data/volumeviz/DicomSample/listOfDicomFiles.dcm");

    m_viewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    final Component component = m_viewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(new JScrollPane(m_sliceView), BorderLayout.LINE_START);
    add(component);
    add(new JScrollPane(m_infoView), BorderLayout.LINE_END);
  }

  @Override
  public void stop()
  {
    m_viewer.dispose();
  }

  public void loadPath(String fileName)
  {
    m_reader.setFilename(fileName);

    DataInfo dataInfo = m_reader.getDataChar();

    m_sliceModel.clear();
    m_sliceModel.setSize(dataInfo.dim.getZ());
    for ( int i = 0; i < dataInfo.dim.getZ(); ++i )
    {
      m_sliceModel.set(i, "Slice #" + i);
    }

    if ( dataInfo.dim.getZ() > 0 )
    {
      m_volumeData.setReader(m_reader);
      m_sliceView.setSelectedIndex(0);
    }

    m_infoView.expandRow(0);
    m_viewer.viewAll();

    MedicalHelper.dicomAdjustDataRange( m_dataRange, m_volumeData );
    MedicalHelper.orientView(MedicalHelper.Axis.AXIAL, m_viewer.getRenderArea().getRootSceneGraph().getCamera(), m_volumeData);


  }

}
