/*----------------------------------------------------------------------------------------
 * Example program.
 * Purpose : Demonstrate how to implement a custom SoLDMConverter
 * author : Jean-Michel Godinaud
 /*----------------------------------------------------------------------------------------*/
package volumeviz.sample.genericConverter.withDefaultReader;
import java.nio.ByteBuffer;

import com.openinventor.inventor.SbVec3i32;
import com.openinventor.ldm.nodes.SoDataSet;
import com.openinventor.volumeviz.converters.SoVolumeConverter;

import util.Example;

public class Main extends Example
{

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Data Converter");
  }

  @Override
  public void start()
  {
    String fileName = "$OIVJHOME/data/volumeviz/3DHEAD.VOL";

    String argss[] = new String[4];
    argss[0] = " ";
    argss[1] = fileName;
    argss[2] = "-o";
    argss[3] = "./3DHEAD.ldm";

    GenericConverter converter = new GenericConverter();
    converter.convert(argss);
  }

  @Override
  public void stop()
  {}

  public class GenericConverter extends SoVolumeConverter {
    public GenericConverter() {
      super(false);
    }
    @Override
    public boolean progress( int numTilesGenerated, int numTilesToGenerate ) {
      System.out.println("---> progress : " + numTilesGenerated + "/" + numTilesToGenerate);
      return true;
    }
    @Override
    public String getXmlTags() {
      // these tags will be inserted in the ldm header file
      return "<myTags></myTags>\n";
    }
    @Override
    public void sampleTile(SbVec3i32 tile_dim, int data_type, int border,
                           ByteBuffer[] octant_tiles, ByteBuffer ptile) {

      SbVec3i32 halfTile2 = tile_dim.times(0.5);
      SbVec3i32 halfTile1 = tile_dim.minus(halfTile2);
      int tileDim1 = tile_dim.getX();
      int tileDim2 = tile_dim.getX() * tile_dim.getY();

      int byte_per_data;
      switch (SoDataSet.DataTypes.valueOf(data_type)) {
      case UNSIGNED_INT32:
      case SIGNED_INT32:
      case FLOAT:
        byte_per_data = 4;
        break;
      case UNSIGNED_SHORT:
      case SIGNED_SHORT:
        byte_per_data = 2;
        break;
      case UNSIGNED_BYTE:
      case SIGNED_BYTE:
      default:
        byte_per_data = 1;
        break;
      }

      for (byte octant = 0; octant < 8; octant++) {

        if (octant_tiles[octant] != null) {

          ByteBuffer otile = octant_tiles[octant];

          int ijkshiftp = 0, ijkshifto = 0;
          if ( (octant & 1) != 0 ) { ijkshifto  = 1       ; ijkshiftp  =            halfTile1.getX(); }
          if ( (octant & 2) != 0 ) { ijkshifto |= tileDim1; ijkshiftp |= tileDim1 * halfTile1.getY(); }
          if ( (octant & 4) != 0 ) { ijkshifto |= tileDim2; ijkshiftp |= tileDim2 * halfTile1.getZ(); }
          ijkshifto *= border;
          for (int k = 0; k < halfTile1.getZ()*tileDim2; k+=tileDim2) {
            for (int j = 0; j < halfTile1.getY()*tileDim1; j+=tileDim1) {
              for (int i = 0; i < halfTile1.getX(); i++) {
                int iparent = (k | j | i);
                int ioctant = (iparent << 1) | ijkshifto;
                iparent |= ijkshiftp;
                for (int l=0; l<byte_per_data; l++) {
                  byte b = otile.get(ioctant+l);
                  ptile.put(iparent+l,b);
                }
              }
            }
          }

        } else {
          // set tile to zero
          int ijkshiftp = 0;
          if ( (octant & 1) != 0 ) { ijkshiftp  =            halfTile1.getX(); }
          if ( (octant & 2) != 0 ) { ijkshiftp |= tileDim1 * halfTile1.getY(); }
          if ( (octant & 4) != 0 ) { ijkshiftp |= tileDim2 * halfTile1.getZ(); }
          for (int k = 0; k < halfTile2.getZ()*tileDim2; k+=tileDim2) {
            for (int j = 0; j < halfTile2.getY()*tileDim1; j+=tileDim1) {
              for (int i = 0; i < halfTile2.getX(); i++) {
                int iparent = (k | j | i | ijkshiftp);
                for (int l=0; l<byte_per_data; l++) {
                  ptile.put(iparent+l,(byte)0);
                }
              }
            }
          }

        }

      }

    }


  }
}

