package volumeviz.sample.getLDMData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.draggers.SoDragger;
import com.openinventor.inventor.draggers.SoJackDragger;
import com.openinventor.inventor.misc.callbacks.SoDraggerCB;
import com.openinventor.inventor.nodes.SoBaseColor;
import com.openinventor.inventor.nodes.SoEventCallback;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.sensors.SoNodeSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.manips.SoROIManip;
import com.openinventor.ldm.nodes.SoLDMResourceParameters;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRender.SamplingAlignments;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;

import util.Example;
import util.ViewerComponentsFactory;

public class LDMData extends Example
{
  private boolean m_hasPlaneDragger = false;
  protected boolean m_toggleViewData;
  protected boolean m_firstTime;
  protected int m_resolution;

  private JFrame m_viewer2Frame = null;
  private JFrame m_mainWindow;
  private JPanel m_viewersPanel;
  private Dimension m_bigFrameDim;
  private JButton m_splitButton;
  private JButton m_mergeButton;

  protected SoSeparator m_root;
  protected SoSeparator m_root2;
  protected SoSeparator m_root3;
  protected SoJackDragger m_planeDragger;
  protected SoVolumeData m_pVolData;
  protected SoROIManip m_pROIManip;
  protected IViewerExaminer m_viewer1;
  protected IViewerExaminer m_viewer2;
  protected SoEventCallback m_eventCB;

  private SoNodeSensor m_roiSensor;

  @Override
  public void start() {
    m_mainWindow = null;

    m_viewer1 = ViewerComponentsFactory.createViewerExaminer();
    m_viewer2 = ViewerComponentsFactory.createViewerExaminer();

    m_root = new SoSeparator();
    m_root2 = new SoSeparator();
    m_root3 = new SoSeparator();
    m_eventCB = new SoEventCallback();

    m_toggleViewData = true;
    m_firstTime = true;
    m_resolution = 0;
  }

  @Override
  public void stop() {
    m_viewer1.dispose();
    m_viewer2.dispose();
    if (m_viewer2Frame != null)
      m_viewer2Frame.dispose();
  }

  protected void updateView2(){}

  protected void addJackDragger(SbRotation rot){
    // Plane manipulator
    m_planeDragger = new SoJackDragger();
    m_planeDragger.rotation.setValue(rot);
    m_planeDragger.addMotionCallback(new PlaneDraggerCB(), null);
    m_hasPlaneDragger = true;
  }

  protected void viewer1Settings() {
    // Node to hold the volume data
    m_pVolData = new SoVolumeData();
    m_pVolData.fileName.setValue("$OIVJHOME/data/volumeviz/3DHEAD.ldm");
    m_pVolData.storageHint.setValue(SoVolumeData.StorageHints.TEX3D);

    //getting data is faster in ALWAYS mode
    m_pVolData.ldmResourceParameters.getValue().loadPolicy.setValue(SoLDMResourceParameters.LoadPolicies.ALWAYS);

    // Use a predefined colorMap with the SoTransferFunction
    SoTransferFunction pTransFunc = new SoTransferFunction();
    pTransFunc.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.SEISMIC);
    pTransFunc.minValue.setValue(30);
    pTransFunc.maxValue.setValue(255);

    // ROI / ROIManip
    // Initialize both ROI box and subvolume to be the entire volume.
    // Constrain the ROIManip to stay inside the volume.
    SbVec3i32 dimensions = m_pVolData.data.getSize();
    m_pROIManip = new SoROIManip();
    m_pROIManip.box.setValue(new SbVec3i32(0, 0, 0),
    		dimensions.minus(new SbVec3i32(1, 1, 1)));
    m_pROIManip.subVolume.setValue(new SbVec3i32(0, 0, 0),
    		dimensions.minus(new SbVec3i32(1, 1, 1)));
    m_pROIManip.constrained.setValue(true);
    m_pROIManip.boxOn.setValue(false);

    SoVolumeRenderingQuality pVolQuality = new SoVolumeRenderingQuality();
    pVolQuality.deferredLighting.setValue(true);
    pVolQuality.preIntegrated.setValue(true);

    // Node in charge of drawing the volume
    SoVolumeRender pVolRender = new SoVolumeRender();
    pVolRender.samplingAlignment.setValue(SamplingAlignments.BOUNDARY_ALIGNED);

    { // Assemble the scene graph
      // Note: SoVolumeRender must appear after the SoVolumeData node.
      m_root.addChild(m_eventCB);
      if (m_hasPlaneDragger)
        m_root.addChild(m_planeDragger);
      m_root.addChild(m_pVolData);
      m_root.addChild(m_pROIManip);
      m_root.addChild(pTransFunc);
      m_root.addChild(pVolQuality);
      m_root.addChild(pVolRender);
    }
  }

  protected void setUpViewers()
  {
    // Set up viewer 1
    m_viewer1.setSceneGraph(m_root);
    m_viewer1.viewAll();

    // Set up viewer 2
    m_viewer2.setSceneGraph(m_root2);
    m_viewer2.viewAll();

    // feed backs
    Runnable run = new Runnable() {
      @Override
      public void run() {
        updateView2();
      }
    };

    m_roiSensor = new SoNodeSensor(run);
    m_roiSensor.attach(m_pROIManip);

    final Component component1 = m_viewer1.getComponent();
    final Component component2 = m_viewer2.getComponent();
    m_viewersPanel = new JPanel(new GridLayout(1, 2));
    component1.setPreferredSize(new java.awt.Dimension(600, 500));
    component2.setPreferredSize(new java.awt.Dimension(600, 500));
    m_viewersPanel.add(component1);
    m_viewersPanel.add(component2);

    m_splitButton = new JButton("Split Window");
    m_splitButton.addMouseListener(new SplitListener());
    m_mergeButton = new JButton("Merge Window");
    m_mergeButton.setEnabled(false);
    m_mergeButton.addMouseListener(new MergeListener());
    JToolBar button_bar = new JToolBar("Options");
    button_bar.add(m_splitButton);
    button_bar.add(m_mergeButton);

    setLayout(new BorderLayout());
    add(m_viewersPanel);
    add(button_bar, BorderLayout.NORTH);
  }

  protected void menuSettings() {
    SoLightModel lightModel = new SoLightModel();
    lightModel.model.setValue(SoLightModel.Models.BASE_COLOR);

    SoFont font;
    SoBaseColor menuColor;
    SoTranslation menuPos;

    { // menu settings
      font = new SoFont();
      font.name.set("Courier New");
      font.size.setValue(12);

      menuColor = new SoBaseColor();
      menuColor.rgb.setValue(1, 1, 0);

      menuPos = new SoTranslation();
      menuPos.translation.setValue(-0.95f, 0.95f, 0.0f);
    }

    SbColor bkgColor = new SbColor(new SbColor(0.4f, 0.4f, 0.4f));
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    {
      m_root2.addChild(background);
      m_root2.addChild(m_eventCB);
      m_root2.addChild(lightModel);
      m_root2.addChild(font);
      m_root2.addChild(menuColor);
      m_root2.addChild(menuPos);
    }
  }

  class PlaneDraggerCB extends SoDraggerCB {
    @Override
    public void invoke(SoDragger dragger) {
      updateView2();
    }
  }

  class SplitListener extends MouseAdapter {
    @Override
    public void mouseReleased(MouseEvent e) {
      if (m_splitButton.isEnabled()) {
        if ( m_mainWindow == null )
        {
          Container parent = getParent();
          while ( parent != null && !(parent instanceof JFrame) )
            parent = parent.getParent();
          m_mainWindow = (JFrame) parent;
        }

        final Component component1 = m_viewer1.getComponent();
        final Component component2 = m_viewer2.getComponent();
        m_bigFrameDim = m_mainWindow.getSize();
        m_viewersPanel.remove(component2);
        m_viewer2Frame = new JFrame("Data");
        m_viewer2Frame.getContentPane().add(component2);
        m_viewer2Frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        m_viewer2Frame.pack();
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        m_viewer2Frame.setLocation( (int) screen_size.getWidth() / 4,
                                   (int) screen_size.getHeight() / 4);
        m_viewer2Frame.setVisible(true);
        m_splitButton.setEnabled(false);
        m_mergeButton.setEnabled(true);
        m_mainWindow.setSize(component1.getWidth(),
            component1.getHeight() + m_splitButton.getHeight() +
                              10);
        m_mainWindow.validate();
        m_mainWindow.repaint();
      }
    }
  }

  public class MergeListener extends MouseAdapter {
    @Override
    public void mouseReleased(MouseEvent e) {
      if (m_mergeButton.isEnabled()) {
        m_viewer2Frame.dispose();
        m_viewer2Frame = null;

        m_viewersPanel.add(m_viewer2.getComponent());
        m_splitButton.setEnabled(true);
        m_mergeButton.setEnabled(false);
        m_mainWindow.setSize(m_bigFrameDim);
        m_mainWindow.validate();
        m_mainWindow.repaint();
      }
    }
  }
}
