package volumeviz.sample.getLDMData.getDataLine;
import java.nio.ByteBuffer;

import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.*;
import com.openinventor.ldm.SoLDMDataAccess;

import volumeviz.sample.getLDMData.LDMData;

public class Main extends LDMData {
  float m_amplitude = 1.0f;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("GetDataLine");
  }

  @Override
  public void start() {
    super.start();

    /********* Viewer1 *********/
    // Track the keyboard events
    m_eventCB.addEventCallback(SoKeyboardEvent.class, new DataLineKeyEventCB(), null);

    addJackDragger(new SbRotation(new SbVec3f(0, 0, 1), 1.570796325f));
    viewer1Settings();

    /********* Viewer2 *********/
    SoText2 menu;
    { // menu
      menu = new SoText2();
      menu.string.set1Value( 0, "D       : Toggle data" );
      menu.string.set1Value( 1, "UP      : Increase resolution" );
      menu.string.set1Value( 2, "DOWN    : Decrease resolution" );
      menu.string.set1Value( 3, "PAGEUP  : Increase amplitude" );
      menu.string.set1Value( 4, "PAGEDOWN: Decrease amplitude" );
      menu.string.set1Value( 5, "XYZ     : Axis alignment" );
    }
    {
      menuSettings();
      m_root2.addChild(menu);
      m_root2.addChild(m_root3);
    }

    setUpViewers();
  }

  @Override
  protected void updateView2() {
    SbVec3i32 dim = m_pVolData.getDimension();

    SbLine line = new SbLine();
    { // get line
      SbVec3f linePosition = m_planeDragger.translation.getValue();
      // rotate the plane's normal by the dragger rotation
      SbRotation rotation = m_planeDragger.rotation.getValue();
      SbVec3f lineDirection = new SbVec3f();
      lineDirection = rotation.multVec(new SbVec3f(0,1,0));
      SbLine lineXYZ = new SbLine(linePosition, linePosition.plus(lineDirection));

      // line in data coordinates
      SbMatrix mx = new SbMatrix();
      mx.makeIdentity();
      SbVec3f volmin = m_pVolData.extent.getValue().getMin();
      SbVec3f volmax = m_pVolData.extent.getValue().getMax();
      mx.setElement(0, 0, dim.getX() / (volmax.getX() - volmin.getX()));
      mx.setElement(0, 3, -mx.getElement(0, 0) * volmin.getX());
      mx.setElement(1, 1, dim.getY()/(volmax.getY()-volmin.getY()));
      mx.setElement(1, 3, -mx.getElement(1, 1)*volmin.getY());
      mx.setElement(2, 2, dim.getZ()/(volmax.getZ()-volmin.getZ()));
      mx.setElement(2, 3, -mx.getElement(2, 2)*volmin.getZ());
      line = mx.multLineMatrix(lineXYZ);
    }

    SbBox3i32 box = new SbBox3i32(m_pROIManip.subVolume.getValue().getMin(),
                              m_pROIManip.subVolume.getValue().getMax());
    SoLDMDataAccess.DataInfoLine info;
    info = m_pVolData.getLdmDataAccess().getData(m_resolution, box, line);

    SoDrawStyle lineStyle = new SoDrawStyle();
    lineStyle.style.setValue(SoDrawStyle.Styles.LINES);

    SoSeparator volSep = new SoSeparator();
    {
      SoTranslation volTr = new SoTranslation();
      volTr.translation.setValue(new SbVec3f(dim.getX() / 2.f,
                                             dim.getY() / 2.f,
                                             dim.getZ() / 2.f));

      SoBaseColor volColor = new SoBaseColor();
      volColor.rgb.setValue(0.9f, 0.9f, 0.9f);

      SoCube vol = new SoCube();
      vol.width.setValue(dim.getX());
      vol.height.setValue(dim.getY());
      vol.depth.setValue(dim.getZ());

      volSep.addChild(volTr);
      volSep.addChild(volColor);
      volSep.addChild(vol);
    }

    SoSeparator roiSep = new SoSeparator();
    {
      SbVec3i32 roiMin = box.getMin();
      SbVec3i32 roiDim = box.getMax().minus(roiMin).plus(new SbVec3i32(1, 1, 1));

      SoTranslation volTr = new SoTranslation();
      volTr.translation.setValue(new SbVec3f(roiMin.getX() + roiDim.getX()/2.f,
                                             roiMin.getY() + roiDim.getY()/2.f,
                                             roiMin.getZ() + roiDim.getZ()/2.f));

      SoBaseColor roiColor = new SoBaseColor();
      roiColor.rgb.setValue(1, 0, 0);

      SoCube roi = new SoCube();
      roi.width.setValue(roiDim.getX());
      roi.height.setValue(roiDim.getY());
      roi.depth.setValue(roiDim.getZ());

      roiSep.addChild(volTr);
      roiSep.addChild(roiColor);
      roiSep.addChild(roi);
    }

    {
      m_root3.removeAllChildren();
      m_root3.addChild(lineStyle);
      m_root3.addChild(volSep);
      m_root3.addChild(roiSep);
    }

    if (info.errorFlag == SoLDMDataAccess.ErrorValues.CORRECT.getValue()) {
      SbVec3f[] vsegment = {new SbVec3f(), new SbVec3f()};
      SbVec3f[] vline = {new SbVec3f(), new SbVec3f()};

      for (int i = 0; i < 2; i++) {
        vsegment[i].setX(info.lineCoord[i].getX());
        vsegment[i].setY(info.lineCoord[i].getY());
        vsegment[i].setZ(info.lineCoord[i].getZ());
      }
      vline[0] = vsegment[0].minus(vsegment[1].minus(vsegment[0]));
      vline[1] = vsegment[1].minus(vsegment[1].minus(vsegment[0]));

      SoBaseColor lineColor = new SoBaseColor();
      lineColor.rgb.setValue(0.3f, 0.7f, 0.5f);

      SoDrawStyle segmentWidthStyle = new SoDrawStyle();
      segmentWidthStyle.style.setValue(SoDrawStyle.Styles.LINES);
      segmentWidthStyle.lineWidth.setValue(5.f);

      SoLineSet segment = new SoLineSet();
      SoVertexProperty vp = new SoVertexProperty();
      vp.vertex.setValues(0, vsegment);
      segment.vertexProperty.setValue(vp);
      segment.numVertices.set1Value(0, 2);

      SoDrawStyle lineWidthStyle = new SoDrawStyle();
      lineWidthStyle.style.setValue(SoDrawStyle.Styles.LINES);

      SoLineSet lineSet = new SoLineSet();
      vp = new SoVertexProperty();
      vp.vertex.setValues(0, vline);
      lineSet.vertexProperty.setValue(vp);
      lineSet.numVertices.set1Value(0, 2);

      {
        m_root3.addChild(lineColor);
        m_root3.addChild(segmentWidthStyle);
        m_root3.addChild(segment);
        m_root3.addChild(lineWidthStyle);
        m_root3.addChild(lineSet);
      }
    }

    if (m_toggleViewData && info.bufferSize > 0) {
      int i;
      SoCpuBufferObject cpuBufferObject = new SoCpuBufferObject();
      cpuBufferObject.setSize(info.bufferSize);
      info = m_pVolData.getLdmDataAccess().getData(m_resolution, box, line, cpuBufferObject);

      // the curve will be drawn onto the plane built against the line and a upvector
      SbVec3f[] vsegment = {new SbVec3f(), new SbVec3f()};
      for (i = 0; i < 2; i++) {
        vsegment[i].setX(info.lineCoord[i].getX());
        vsegment[i].setY(info.lineCoord[i].getY());
        vsegment[i].setZ(info.lineCoord[i].getZ());
      }
      SbVec3f dsegment = vsegment[1].minus(vsegment[0]);

      SbVec3f axis = dsegment.getClosestAxis();
      SbVec3f upvector = new SbVec3f();
      if (axis.getX() != 0) {
        if (dsegment.getX() > 0)
          upvector.setValue( -dsegment.getY(), dsegment.getX(), 0);
        else
          upvector.setValue(dsegment.getY(), -dsegment.getX(), 0);
      }
      else if (axis.getY() != 0) {
        if (dsegment.getY() > 0)
          upvector.setValue(dsegment.getY(), -dsegment.getX(), 0);
        else
          upvector.setValue( -dsegment.getY(), dsegment.getX(), 0);
      }
      else {
        if (dsegment.getZ() > 0)
          upvector.setValue(0, dsegment.getZ(), -dsegment.getY());
        else
          upvector.setValue(0, -dsegment.getZ(), dsegment.getY());
      }
      upvector.normalize();

      SoLineSet curve = new SoLineSet();
      SoVertexProperty vp = new SoVertexProperty();

      int n = info.bufferDimension;
      if ( cpuBufferObject.getSize() > 0 )
      {
        ByteBuffer buffer = cpuBufferObject.map(SoCpuBufferObject.AccessModes.READ_ONLY);

        for ( i = 0; i < n; i++ )
        {
          float value = buffer.get();
          float u = (float) i / (n - 1);
          float v = 5.f + m_amplitude / 10.f * value;
          SbVec3f p = vsegment[0].plus(dsegment.times(u).plus(upvector.times(v)));
          vp.vertex.set1Value(i, p);
        }
        cpuBufferObject.unmap();
      }
      curve.vertexProperty.setValue(vp);
      curve.numVertices.set1Value(0, n);

      m_root3.addChild(curve);
    }

    if (m_firstTime) {
      m_viewer2.viewAll();
      m_firstTime = false;
    }
  }

  class DataLineKeyEventCB extends SoEventCallbackCB {
    @Override
    public void invoke(SoEventCallback e) {
      SoKeyboardEvent key_event = (SoKeyboardEvent)e.getEvent();

      if (SoKeyboardEvent.isKeyPressEvent(key_event, key_event.getKey())) {
        switch (key_event.getKey()) {
          case D:
            m_toggleViewData = !m_toggleViewData;
            break;
          case UP_ARROW:
            if (m_resolution > 0)
              m_resolution--;
            break;
          case DOWN_ARROW:
            m_resolution++;
            break;
          case PAGE_UP:
            m_amplitude *= 1.3f;
            break;
          case PAGE_DOWN:
            m_amplitude /= 1.3f;
            break;
          case X:
            m_planeDragger.rotation.setValue(new SbRotation(new SbVec3f(0, 0, 1),
                1.570796325f));
            break;
          case Y:
            m_planeDragger.rotation.setValue(new SbRotation(new SbVec3f(0, 1, 0),
                1.570796325f));
            break;
          case Z:
            m_planeDragger.rotation.setValue(new SbRotation(new SbVec3f(1, 0, 0),
                1.570796325f));
            break;
          default:
            return;
        }
        m_pROIManip.touch();
      }
    }
  }
}
