package volumeviz.sample.ldm2d_rgb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import javax.imageio.ImageIO;

import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbDataType;
import com.openinventor.inventor.SbDataType.DataTypes;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.fields.SoSFArray;
import com.openinventor.inventor.nodes.SoFragmentShader;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShaderObject;
import com.openinventor.inventor.nodes.SoShaderParameter1i;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoMultiDataSeparator;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoOrthoSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeShader;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    BufferedImage image;
    try {
    	image = ImageIO.read(new File(SoPreferences.getValue("OIVJHOME") + "/data/volumeviz/big_image.jpg"));
    } catch(IOException e) {
    	e.printStackTrace();
    	return;
    }

    int dimX = image.getWidth();
    int dimY = image.getHeight();
    int numBytes = dimX * dimY;

    ByteBuffer dataApp1 = ByteBuffer.allocateDirect(numBytes);
    dataApp1.order(ByteOrder.nativeOrder());
    ByteBuffer dataApp2 = ByteBuffer.allocateDirect(numBytes);
    dataApp2.order(ByteOrder.nativeOrder());
    ByteBuffer dataApp3 = ByteBuffer.allocateDirect(numBytes);
    dataApp3.order(ByteOrder.nativeOrder());

    for (int y = 0; y < dimY; y++) {
        for (int x = 0; x < dimX; x++) {
        	int rgb = image.getRGB(x, y);
        	dataApp1.put((byte)( (rgb & 0x00ff0000) >> 16));
        	dataApp2.put((byte)( (rgb & 0x0000ff00) >>  8));
        	dataApp3.put((byte)( (rgb & 0x000000ff) >>  0));
        }
    }

    SbVec3i32 dims = new SbVec3i32(dimX, dimY, 1);
    SbBox3f box = new SbBox3f(0, 0, 0, dimX, dimY, 1);

    SbDataType dataType = new SbDataType(DataTypes.UNSIGNED_BYTE);
    // Node to hold the volume data
    // In the first call we specify the voxel dimensions and the actual data.
    // In the second call we specify the 3D extent of the volume in modeling coords.
    SoVolumeData pVolData1 = new SoVolumeData();
    pVolData1.data.setValue( dims, dataType, dataApp1, SoSFArray.CopyPolicies.NO_COPY);
    pVolData1.extent.setValue( box );
    pVolData1.dataSetId.setValue((short)1);

    SoVolumeData pVolData2 = new SoVolumeData();
    pVolData2.data.setValue( dims, dataType, dataApp2, SoSFArray.CopyPolicies.NO_COPY );
    pVolData2.extent.setValue( box );
    pVolData2.dataSetId.setValue((short)2);

    SoVolumeData pVolData3 = new SoVolumeData();
    pVolData3.data.setValue( dims, dataType, dataApp3, SoSFArray.CopyPolicies.NO_COPY );
    pVolData3.extent.setValue( box );
    pVolData3.dataSetId.setValue((short)3);


    //try to fix the bug, doesn't work anyway....
    pVolData1.ldmResourceParameters.getValue().tileDimension.setValue(256, 256, 1);
    pVolData2.ldmResourceParameters.getValue().tileDimension.setValue(256, 256, 1);
    pVolData3.ldmResourceParameters.getValue().tileDimension.setValue(256, 256, 1);

    // Use a predefined colorMap with the SoTransferFunction
    SoTransferFunction pTransFunc = new SoTransferFunction();
    pTransFunc.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.INTENSITY);

    // Node in charge of drawing the volume
    SoOrthoSlice pOrthoSlice = new SoOrthoSlice();
    // use or not pixel interpolation
    //pOrthoSlice.interpolation=SoVolumeShape.NEAREST;

    // Specify how to combine data with each other
    SoFragmentShader fragmentShader = new SoFragmentShader();
    fragmentShader.sourceType.setValue(SoShaderObject.SourceTypes.FILENAME);

    String pkgName = this.getClass().getPackage().getName();
    pkgName = pkgName.replace('.', File.separatorChar);
    String prefix =
        SoPreferences.getValue("OIVJHOME") + File.separator + "examples" + File.separator + pkgName + File.separator;
    fragmentShader.sourceProgram.setValue(prefix + "RGB.glsl");

    // Create uniform parameters allowing shader to access textures
    //
    // Transfer function is in texture unit 0 (default)
    SoShaderParameter1i paramTex0 = new SoShaderParameter1i();
    paramTex0.name.setValue("transfer");
    paramTex0.value.setValue(0);

    // Volume data is in texture unit 1 (default)
    SoShaderParameter1i paramTex1 = new SoShaderParameter1i();
    paramTex1.name.setValue("data1");
    paramTex1.value.setValue(1);

    SoShaderParameter1i paramTex2 = new SoShaderParameter1i();
    paramTex2.name.setValue("data2");
    paramTex2.value.setValue(2);

    SoShaderParameter1i paramTex3 = new SoShaderParameter1i();
    paramTex3.name.setValue("data3");
    paramTex3.value.setValue(3);


    fragmentShader.parameter.set1Value(0, paramTex1);
    fragmentShader.parameter.set1Value(1, paramTex2);
    fragmentShader.parameter.set1Value(2, paramTex3);

    // Initialize and set the volume shader program
    SoVolumeShader pVolShader = new SoVolumeShader();
    // Specify to what part the shader prog is intended to. Here fragments only.
    pVolShader.shaderObject.set1Value(SoVolumeShader.ShaderPositions.FRAGMENT_COMPUTE_COLOR.getValue(), fragmentShader);
    // Specify that shader is only applied to slice or skin
    pVolShader.forVolumeOnly.setValue(false);

    // Assemble the scene graph
    // Note: SoVolumeRender must appear after the SoVolumeData node.
    SoSeparator root = new SoSeparator();

    SoMultiDataSeparator mds = new SoMultiDataSeparator();

    mds.addChild( pTransFunc );
    mds.addChild( pVolShader );

    mds.addChild( pVolData1 );
    mds.addChild( pVolData2 );
    mds.addChild( pVolData3 );

    mds.addChild( pOrthoSlice );

    root.addChild(mds);

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String argv[]) {
    Main example = new Main();
    example.demoMain("LDM 2D RGB");
  }

}
