package volumeviz.sample.obliqueSlice;
import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbPlane;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.draggers.SoDragger;
import com.openinventor.inventor.draggers.SoJackDragger;
import com.openinventor.inventor.misc.callbacks.SoDraggerCB;
import com.openinventor.inventor.nodes.SoClipPlane;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoObliqueSlice;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  SoSeparator root;
  SoVolumeData volData;
  SoTransferFunction transFunc;
  SoJackDragger dragger;
  SoObliqueSlice slice;
  SoClipPlane clip;
  SoMaterial material;
  SoPickStyle pick;
  SoVolumeRender volRender;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("ObliqueSlice");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    volData = new SoVolumeData();
    volData.fileName.setValue("$OIVJHOME/data/volumeviz/3DHEAD.ldm");

    transFunc = new SoTransferFunction();
    transFunc.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.STANDARD);
    transFunc.minValue.setValue(20);
    transFunc.maxValue.setValue(255);

    dragger = new SoJackDragger();
    dragger.rotation.setValue(new SbRotation(new SbVec3f(0,1,0), new SbVec3f(0,0,1)));
    dragger.addMotionCallback(new SliceManipCB(), null);

    slice = new SoObliqueSlice();

    clip = new SoClipPlane();
    clip.on.setValue(true);
    clip.plane.connectFrom(slice.plane);

    material = new SoMaterial();
    material.transparency.setValue(.7f);

    pick = new SoPickStyle();
    pick.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    volRender = new SoVolumeRender();
    volRender.numSlicesControl.setValue(SoVolumeRender.NumSlicesControls.ALL);

    { //Assemble scene graph
      root = new SoSeparator();
      root.addChild(volData);
      root.addChild(transFunc);
      root.addChild(dragger);
      root.addChild(slice);
      root.addChild(clip);
      root.addChild(material);
      root.addChild(pick);
      root.addChild(volRender);
    }

    myViewer.getRenderArea().setTransparencyType(SoGLRenderAction.TransparencyTypes.DELAYED_BLEND);
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  class SliceManipCB extends SoDraggerCB {
    @Override
    public void invoke(SoDragger d) {
      SbVec3f planeNormal = new SbVec3f(0,0,1) ;
      SbVec3f draggerPos = dragger.translation.getValue();
      // rotate the plane's normal by the dragger rotation
      SbRotation rotation = dragger.rotation.getValue();
      planeNormal = rotation.multVec(new SbVec3f(0,1,0));

      // translate cross section and cross contour
      slice.plane.setValue(new SbPlane(planeNormal,draggerPos));
    }
  }
}
